/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.nodes.BaseNode;
import org.raml.yagi.framework.nodes.Position;
import org.raml.yagi.framework.nodes.snakeyaml.SYPosition;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public abstract class SYBaseRamlNode
extends BaseNode {
    private Node yamlNode;
    private String resourcePath;
    private final ResourceLoader resourceLoader;

    protected SYBaseRamlNode(SYBaseRamlNode node) {
        super(node);
        this.yamlNode = node.yamlNode;
        this.resourcePath = node.getResourcePath();
        this.resourceLoader = node.getResourceLoader();
    }

    public SYBaseRamlNode(Node yamlNode, String resourcePath, ResourceLoader resourceLoader) {
        this.yamlNode = yamlNode;
        this.resourcePath = resourcePath;
        this.resourceLoader = resourceLoader;
    }

    protected Node getYamlNode() {
        return this.yamlNode;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    @Nonnull
    public Position getStartPosition() {
        return new SYPosition(this.yamlNode.getStartMark(), this.resourceLoader, this.resourcePath);
    }

    @Override
    @Nonnull
    public Position getEndPosition() {
        return new SYPosition(this.yamlNode.getEndMark(), this.resourceLoader, this.resourcePath);
    }

    @Nullable
    public String getLiteralValue() {
        if (this.yamlNode instanceof ScalarNode) {
            return ((ScalarNode)this.getYamlNode()).getValue();
        }
        return null;
    }

    public String toString() {
        return this.getLiteralValue();
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }
}

