/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.xml.reader;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.core.io.StreamingSeekableStream;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.module.core.xml.reader.LimitedResettableInputStream;
import org.mule.weave.v2.module.core.xml.reader.SeekableInputStreamAdapter;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class XmlEncodingDetector$ {
    public static XmlEncodingDetector$ MODULE$;
    private final int BUFFER_SIZE;

    static {
        new XmlEncodingDetector$();
    }

    private int BUFFER_SIZE() {
        return this.BUFFER_SIZE;
    }

    public SourceProvider updateSourceProviderEncoding(SourceProvider sourceProvider, EvaluationContext ctx) {
        SourceProvider sourceProvider2;
        String detectedCharset;
        InputStream inputStream;
        InputStream inputStream2 = sourceProvider.asInputStream(ctx);
        if (inputStream2 instanceof StreamingSeekableStream) {
            StreamingSeekableStream streamingSeekableStream = (StreamingSeekableStream)inputStream2;
            inputStream = new LimitedResettableInputStream((InputStream)streamingSeekableStream, this.BUFFER_SIZE(), ctx);
        } else if (inputStream2 instanceof SeekableStream) {
            SeekableStream seekableStream = (SeekableStream)inputStream2;
            inputStream = new SeekableInputStreamAdapter(seekableStream);
        } else if (inputStream2.markSupported()) {
            inputStream = inputStream2;
        } else if (inputStream2 != null) {
            InputStream inputStream3 = inputStream2;
            inputStream = new LimitedResettableInputStream(inputStream3, this.BUFFER_SIZE(), ctx);
        } else {
            throw new MatchError((Object)inputStream2);
        }
        InputStream is = inputStream;
        String string = sourceProvider.charset().name();
        String string2 = "UTF-16".equals(string) ? "UTF-16BE" : ("UTF-32".equals(string) ? "UTF-32BE" : string);
        String sourceCharset = string2;
        String string3 = detectedCharset = (String)this.detectEncoding(is).getOrElse((Function0 & Serializable & scala.Serializable)() -> sourceCharset);
        String string4 = sourceCharset;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null) && !(is instanceof LimitedResettableInputStream)) {
            sourceProvider2 = sourceProvider;
        } else {
            InputStream inputStream4;
            InputStream inputStream5 = is;
            if (inputStream5 instanceof SeekableInputStreamAdapter) {
                SeekableInputStreamAdapter seekableInputStreamAdapter = (SeekableInputStreamAdapter)inputStream5;
                inputStream4 = (InputStream)seekableInputStreamAdapter.delegate();
            } else {
                inputStream4 = is;
            }
            sourceProvider2 = SourceProvider$.MODULE$.apply(inputStream4, Charset.forName(detectedCharset));
        }
        return sourceProvider2;
    }

    private Option<String> detectEncoding(InputStream is) {
        None$ none$;
        try {
            is.mark(this.BUFFER_SIZE());
            byte[] bom = new byte[this.BUFFER_SIZE()];
            int read = is.read(bom, 0, 4);
            if (read == -1) {
                return None$.MODULE$;
            }
            int n = read;
            switch (n) {
                default: 
            }
            String bomEncoding = read >= 4 && bom[0] == 0 && bom[1] == 0 && bom[2] == (byte)254 && bom[3] == (byte)255 ? "UTF-32BE" : (read >= 4 && bom[0] == (byte)255 && bom[1] == (byte)254 && bom[2] == 0 && bom[3] == 0 ? "UTF-32LE" : (read >= 3 && bom[0] == (byte)239 && bom[1] == (byte)187 && bom[2] == (byte)191 ? "UTF-8" : (read >= 2 && bom[0] == (byte)254 && bom[1] == (byte)255 ? "UTF-16BE" : (read >= 2 && bom[0] == (byte)255 && bom[1] == (byte)254 ? "UTF-16LE" : null))));
            is.reset();
            if (bomEncoding != null) {
                return new Some((Object)bomEncoding);
            }
            byte[] buffer = new byte[128];
            int bytesRead = 0;
            boolean stopReading = false;
            while (bytesRead < 128 && !stopReading) {
                int n2 = is.read();
                if (n2 == -1) {
                    stopReading = true;
                    continue;
                }
                buffer[bytesRead] = (byte)n2;
                ++bytesRead;
                if (n2 != (byte)62) continue;
                stopReading = true;
            }
            is.reset();
            String xmlProlog = new String(buffer, 0, bytesRead, StandardCharsets.UTF_8);
            Regex encodingRegex = new StringOps(Predef$.MODULE$.augmentString("(?i)<\\?xml[^>]*encoding\\s*=\\s*[\"']([^\"']+)[\"']")).r();
            Option declaredEncoding = encodingRegex.findFirstMatchIn((CharSequence)xmlProlog).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.group(1));
            none$ = declaredEncoding;
        }
        catch (Exception exception) {
            is.reset();
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private XmlEncodingDetector$() {
        MODULE$ = this;
        this.BUFFER_SIZE = 128;
    }
}

