/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import com.google.common.primitives.Primitives;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.ClassLoaderResourceNotFoundExceptionFactory;
import org.mule.runtime.core.api.util.ExceptionHandler;
import org.mule.runtime.core.api.util.ExceptionUtils;

public class ClassUtils {
    public static final Object[] NO_ARGS = new Object[0];
    public static final Class<?>[] NO_ARGS_TYPE = new Class[0];
    private static final Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    public static final String MULE_DESIGN_MODE = "mule.designMode";
    private static LazyValue<ClassLoaderResourceNotFoundExceptionFactory> resourceNotFoundExceptionFactoryLazyValue = new LazyValue(() -> StreamSupport.stream(((Iterable)() -> ServiceLoader.load(ClassLoaderResourceNotFoundExceptionFactory.class, ClassUtils.class.getClassLoader()).iterator()).spliterator(), false).findFirst().orElseGet(() -> ClassLoaderResourceNotFoundExceptionFactory.getDefaultFactory()));

    public static boolean isConcrete(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz may not be null");
        }
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        return org.mule.runtime.internal.util.ClassUtils.getResource((String)resourceName, callingClass);
    }

    public static URL getResourceOrFail(String resourceName, ClassLoader classLoader, boolean tryAbsolutePath) {
        URL url = AccessController.doPrivileged(() -> classLoader != null ? classLoader.getResource(resourceName) : null);
        if (url != null) {
            return url;
        }
        if (url == null && tryAbsolutePath && (url = ClassUtils.urlFromAbsolutePath(resourceName)) != null) {
            return url;
        }
        if (ClassUtils.isDesignModeEnabled().booleanValue()) {
            throw ((ClassLoaderResourceNotFoundExceptionFactory)resourceNotFoundExceptionFactoryLazyValue.get()).createResourceNotFoundException(resourceName, classLoader, true);
        }
        throw ClassLoaderResourceNotFoundExceptionFactory.getDefaultFactory().createResourceNotFoundException(resourceName, classLoader, true);
    }

    private static URL urlFromAbsolutePath(String uri) {
        File file = new File(uri);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    public static Boolean isDesignModeEnabled() {
        return Boolean.getBoolean(MULE_DESIGN_MODE);
    }

    public static URL getResourceOrFail(String resourceName, boolean tryAbsolutePath) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return ClassUtils.getResourceOrFail(resourceName, cl, tryAbsolutePath);
    }

    @Deprecated
    public static Enumeration<URL> getResources(String resourceName, Class<?> callingClass) {
        return ClassUtils.getResources(resourceName, callingClass.getClassLoader());
    }

    public static Enumeration<URL> getResources(String resourceName, ClassLoader fallbackClassLoader) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)resourceName) ? 1 : 0) != 0, (String)"ResourceName cannot be empty");
        Preconditions.checkArgument((fallbackClassLoader != null ? 1 : 0) != 0, (String)"FallbackClassLoader cannot be null");
        Enumeration enumeration = AccessController.doPrivileged(() -> {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.getResources(resourceName) : null;
            }
            catch (IOException e) {
                return null;
            }
        });
        if (enumeration == null) {
            enumeration = AccessController.doPrivileged(() -> {
                try {
                    return ClassUtils.class.getClassLoader().getResources(resourceName);
                }
                catch (IOException e) {
                    return null;
                }
            });
        }
        if (enumeration == null) {
            enumeration = AccessController.doPrivileged(() -> {
                try {
                    return fallbackClassLoader.getResources(resourceName);
                }
                catch (IOException e) {
                    return null;
                }
            });
        }
        return enumeration;
    }

    public static Class loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        return ClassUtils.loadClass(className, callingClass, Object.class);
    }

    public static <T extends Class> T loadClass(String className, Class<?> callingClass, T type) throws ClassNotFoundException {
        if (className.length() <= 8 && primitiveTypeNameMap.containsKey(className)) {
            return (T)primitiveTypeNameMap.get(className);
        }
        Class clazz = AccessController.doPrivileged(() -> {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl != null ? cl.loadClass(className) : null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        });
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return ClassUtils.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            clazz = AccessController.doPrivileged(() -> {
                try {
                    return callingClass.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            });
        }
        if (clazz == null) {
            throw new ClassNotFoundException(className);
        }
        if (type.isAssignableFrom(clazz)) {
            return (T)clazz;
        }
        throw new IllegalArgumentException(String.format("Loaded class '%s' is not assignable from type '%s'", clazz.getName(), type.getName()));
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = classLoader.loadClass(org.mule.metadata.java.api.utils.ClassUtils.getInnerClassName((String)className));
            }
            catch (ClassNotFoundException e2) {
                if (ClassUtils.isDesignModeEnabled().booleanValue()) {
                    throw ((ClassLoaderResourceNotFoundExceptionFactory)resourceNotFoundExceptionFactoryLazyValue.get()).createClassNotFoundException(className, classLoader);
                }
                throw ClassLoaderResourceNotFoundExceptionFactory.getDefaultFactory().createClassNotFoundException(className, classLoader);
            }
        }
        return clazz;
    }

    public static Field getField(Class<?> targetClass, String fieldName, boolean recursive) throws NoSuchFieldException {
        Class<?> clazz = targetClass;
        while (!Object.class.equals(clazz)) {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (NoSuchFieldException e) {
                if (!recursive) break;
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException(String.format("Could not find field '%s' in class %s", fieldName, targetClass.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <T> T getFieldValue(Object target, String fieldName, boolean recursive) throws IllegalAccessException, NoSuchFieldException {
        Field f = ClassUtils.getField(target.getClass(), fieldName, recursive);
        boolean isAccessible = f.isAccessible();
        try {
            f.setAccessible(true);
            Object object = f.get(target);
            return (T)object;
        }
        finally {
            f.setAccessible(isAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <T> T getStaticFieldValue(Class<?> targetClass, String fieldName, boolean recursive) throws NoSuchFieldException, IllegalAccessException {
        Field field = ClassUtils.getField(targetClass, fieldName, recursive);
        boolean isAccessible = field.isAccessible();
        if (!Modifier.isStatic(field.getModifiers())) {
            throw new IllegalAccessException(String.format("The %s field of %s class is not static", fieldName, targetClass.getName()));
        }
        try {
            field.setAccessible(true);
            Object object = field.get(null);
            return (T)object;
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    @Deprecated
    private static void removeFinalModifierFromField(Field field) throws NoSuchFieldException, IllegalAccessException {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            return;
        }
        Field modifiersField = ClassUtils.getField(Field.class, "modifiers", false);
        boolean isModifiersFieldAccessible = modifiersField.isAccessible();
        try {
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        finally {
            modifiersField.setAccessible(isModifiersFieldAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void setFieldValue(Object target, String fieldName, Object value, boolean recursive) throws IllegalAccessException, NoSuchFieldException {
        Field field = ClassUtils.getField(target.getClass(), fieldName, recursive);
        boolean isAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void setStaticFieldValue(Class<?> targetClass, String fieldName, Object value, boolean recursive) throws NoSuchFieldException, IllegalAccessException {
        Field field = ClassUtils.getField(targetClass, fieldName, recursive);
        boolean isAccessible = field.isAccessible();
        if (Modifier.isFinal(field.getModifiers())) {
            ClassUtils.removeFinalModifierFromField(field);
        }
        try {
            field.setAccessible(true);
            field.set(null, value);
        }
        finally {
            field.setAccessible(isAccessible);
        }
    }

    public static Class<?> initializeClass(Class<?> clazz) {
        try {
            return org.apache.commons.lang3.ClassUtils.getClass((String)clazz.getName(), (boolean)true);
        }
        catch (ClassNotFoundException e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    public static <T> T instantiateClass(Class<? extends T> clazz, Object ... constructorArgs) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor ctor;
        Class[] args;
        if (constructorArgs != null) {
            args = new Class[constructorArgs.length];
            for (int i = 0; i < constructorArgs.length; ++i) {
                args[i] = constructorArgs[i] == null ? null : constructorArgs[i].getClass();
            }
        } else {
            args = new Class[]{};
        }
        if ((ctor = ClassUtils.getConstructor(clazz, args)) == null) {
            ctor = ClassUtils.getConstructor(clazz, ClassUtils.wrappersToPrimitives(args));
        }
        if (ctor == null) {
            StringBuilder argsString = new StringBuilder(100);
            for (Class arg : args) {
                argsString.append(arg.getName()).append(", ");
            }
            throw new NoSuchMethodException("could not find constructor on class: " + clazz + ", with matching arg params: " + argsString);
        }
        return ctor.newInstance(constructorArgs);
    }

    public static Object instantiateClass(String name, Object ... constructorArgs) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return ClassUtils.instantiateClass(name, constructorArgs, (ClassLoader)null);
    }

    public static Object instantiateClass(String name, Object[] constructorArgs, Class<?> callingClass) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = ClassUtils.loadClass(name, callingClass);
        return ClassUtils.instantiateClass(clazz, constructorArgs);
    }

    public static Object instantiateClass(String name, Object[] constructorArgs, ClassLoader classLoader) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class clazz = classLoader != null ? ClassUtils.loadClass(name, classLoader) : ClassUtils.loadClass(name, ClassUtils.class);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return ClassUtils.instantiateClass(clazz, constructorArgs);
    }

    public static Class<?>[] getParameterTypes(Object bean, String methodName) {
        if (!methodName.startsWith("set")) {
            methodName = "set" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        }
        for (Method method : bean.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method.getParameterTypes();
        }
        return new Class[0];
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?>[] parameterTypes) {
        return ClassUtils.getMethod(clazz, name, parameterTypes, false);
    }

    public static Method getMethod(Class clazz, String name, Class[] parameterTypes, boolean acceptNulls) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            if (parameterTypes == null) {
                return method;
            }
            if (!ClassUtils.compare(method.getParameterTypes(), parameterTypes, true, acceptNulls)) continue;
            return method;
        }
        return null;
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes) {
        return ClassUtils.getConstructor(clazz, paramTypes, false);
    }

    public static Constructor getConstructor(Class clazz, Class[] paramTypes, boolean exactMatch) {
        for (Constructor<?> ctor : clazz.getConstructors()) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != paramTypes.length) continue;
            int matchCount = 0;
            for (int x = 0; x < types.length; ++x) {
                if (paramTypes[x] == null) {
                    ++matchCount;
                    continue;
                }
                if (exactMatch) {
                    if (!paramTypes[x].equals(types[x]) && !types[x].equals(paramTypes[x])) continue;
                    ++matchCount;
                    continue;
                }
                if (!paramTypes[x].isAssignableFrom(types[x]) && !types[x].isAssignableFrom(paramTypes[x])) continue;
                ++matchCount;
            }
            if (matchCount != types.length) continue;
            return ctor;
        }
        return null;
    }

    public static boolean isClassOnPath(String className, Class currentClass) {
        try {
            return ClassUtils.loadClass(className, currentClass) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?>[] getClassTypes(Object object) {
        Class[] types;
        if (object == null) {
            return NO_ARGS_TYPE;
        }
        if (object instanceof Object[]) {
            Object[] objects = (Object[])object;
            if (objects.length == 0) {
                return NO_ARGS_TYPE;
            }
            types = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                Object o = objects[i];
                if (o == null) continue;
                types[i] = o.getClass();
            }
        } else {
            types = new Class[]{object.getClass()};
        }
        return types;
    }

    public static String getClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.getSimpleName();
    }

    public static boolean compare(Class[] c1, Class[] c2, boolean matchOnObject, boolean acceptNulls) {
        if (c1.length != c2.length) {
            return false;
        }
        for (int i = 0; i < c1.length; ++i) {
            if (!acceptNulls) {
                if (c1[i] == null || c2[i] == null) {
                    return false;
                }
            } else {
                if (c1[i] == null) {
                    return false;
                }
                if (c2[i] == null && c1[i].isPrimitive()) {
                    return false;
                }
                if (c2[i] == null) {
                    return true;
                }
            }
            if (c1[i].equals(Object.class) && !matchOnObject) {
                return false;
            }
            if (org.apache.commons.lang3.ClassUtils.primitiveToWrapper((Class)c1[i]).isAssignableFrom(org.apache.commons.lang3.ClassUtils.primitiveToWrapper((Class)c2[i]))) continue;
            return false;
        }
        return true;
    }

    public static Class[] wrappersToPrimitives(Class[] wrappers) {
        if (wrappers == null) {
            return null;
        }
        if (wrappers.length == 0) {
            return wrappers;
        }
        Class[] primitives = new Class[wrappers.length];
        for (int i = 0; i < wrappers.length; ++i) {
            primitives[i] = wrapperToPrimitiveMap.getOrDefault(wrappers[i], wrappers[i]);
        }
        return primitives;
    }

    public static String getSimpleName(Class clazz) {
        if (null == clazz) {
            return "null";
        }
        return ClassUtils.classNameHelper(new BufferedReader(new CharArrayReader(clazz.getName().toCharArray())));
    }

    private static String classNameHelper(Reader encodedName) {
        try {
            encodedName.mark(1);
            switch (encodedName.read()) {
                case -1: {
                    return "null";
                }
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 68: {
                    return "double";
                }
                case 70: {
                    return "float";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 83: {
                    return "short";
                }
                case 91: {
                    return ClassUtils.classNameHelper(encodedName) + "[]";
                }
                case 76: {
                    return ClassUtils.shorten(new BufferedReader(encodedName).readLine());
                }
            }
            encodedName.reset();
            return ClassUtils.shorten(new BufferedReader(encodedName).readLine());
        }
        catch (IOException e) {
            return "unknown type: " + e.getMessage();
        }
    }

    private static String shorten(String clazz) {
        if (null != clazz && clazz.endsWith(";")) {
            clazz = clazz.substring(0, clazz.length() - 1);
        }
        if (null != clazz && clazz.lastIndexOf(".") > -1) {
            clazz = clazz.substring(clazz.lastIndexOf(".") + 1, clazz.length());
        }
        return clazz;
    }

    public static boolean equal(Object a, Object b) {
        if (null == a) {
            return null == b;
        }
        return null != b && a.equals(b);
    }

    public static int hash(Object[] state) {
        int hash = 0;
        for (Object element : state) {
            hash = hash * 31 + (null == element ? 0 : element.hashCode());
        }
        return hash;
    }

    public static URL getClassPathRoot(Class clazz) {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        return cs != null ? cs.getLocation() : null;
    }

    public static Class<? extends Annotation> resolveAnnotationClass(Annotation annotation) {
        if (Proxy.isProxyClass(annotation.getClass())) {
            return annotation.getClass().getInterfaces()[0];
        }
        return annotation.getClass();
    }

    public static <T> boolean isInstance(Class<T> type, Object value) {
        if (value == null) {
            return false;
        }
        if (type.isInstance(value)) {
            return true;
        }
        Class<?> valueType = value.getClass();
        return ClassUtils.isWrapperAndPrimitivePair(type, valueType);
    }

    private static boolean isWrapperAndPrimitivePair(Class<?> type1, Class<?> type2) {
        if (ClassUtils.isPrimitiveWrapper(type1)) {
            return type2.equals(Primitives.unwrap(type1));
        }
        if (ClassUtils.isPrimitiveWrapper(type2)) {
            return type1.equals(Primitives.unwrap(type2));
        }
        return false;
    }

    private static <T> boolean isPrimitiveWrapper(Class<T> type) {
        return Primitives.isWrapperType(type);
    }

    @Deprecated
    public static void withContextClassLoader(ClassLoader classLoader, Runnable runnable) {
        try {
            ClassUtils.withContextClassLoader(classLoader, runnable, RuntimeException.class, (Exception e) -> {
                throw new MuleRuntimeException((Throwable)e);
            });
        }
        catch (Exception e2) {
            throw new MuleRuntimeException((Throwable)e2);
        }
    }

    public static <T> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable) {
        return (T)ClassUtils.withContextClassLoader(classLoader, callable, RuntimeException.class, (Exception e) -> {
            throw new MuleRuntimeException((Throwable)e);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> void withContextClassLoader(ClassLoader classLoader, Runnable runnable, Class<E> expectedExceptionType, ExceptionHandler<T, E> exceptionHandler) throws E {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            currentThread.setContextClassLoader(classLoader);
        }
        try {
            ExceptionUtils.tryExpecting(expectedExceptionType, runnable, exceptionHandler);
        }
        finally {
            if (currentClassLoader != classLoader) {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T withContextClassLoader(ClassLoader classLoader, Callable<T> callable, Class<E> expectedExceptionType, ExceptionHandler<T, E> exceptionHandler) throws E {
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        if (currentClassLoader != classLoader) {
            currentThread.setContextClassLoader(classLoader);
        }
        try {
            T t = ExceptionUtils.tryExpecting(expectedExceptionType, callable, exceptionHandler);
            return t;
        }
        finally {
            if (currentClassLoader != classLoader) {
                currentThread.setContextClassLoader(currentClassLoader);
            }
        }
    }

    public static void setContextClassLoader(Thread thread, ClassLoader currentClassLoader, ClassLoader newClassLoader) {
        if (currentClassLoader != newClassLoader) {
            thread.setContextClassLoader(newClassLoader);
        }
    }

    public static <I, O> Function<I, O> memoize(Function<I, O> f, Map<I, O> cache) {
        return input -> cache.computeIfAbsent(input, f);
    }

    public static Class<?>[] findImplementedInterfaces(Class<?> aClass) {
        Preconditions.checkArgument((aClass != null ? 1 : 0) != 0, (String)"Class to analyze cannot be null");
        LinkedList foundInterfaces = new LinkedList();
        for (Class<?> currentClass = aClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Class<?>[] interfaces = currentClass.getInterfaces();
            Collections.addAll(foundInterfaces, interfaces);
        }
        return foundInterfaces.toArray(new Class[0]);
    }

    private ClassUtils() {
    }

    static {
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Void.TYPE, Void.TYPE);
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(wrapperToPrimitiveMap.values());
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
    }
}

