/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.internal.artifact;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class LibraryByJavaVersion {
    private static final Pattern DASH_VERSION = Pattern.compile("-(\\d+(\\.|$))");
    private static final Pattern NON_ALPHANUM = Pattern.compile("[^A-Za-z0-9]");
    private static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
    private static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
    private static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");
    private final int javaVersion;
    private final String libraryName;
    private final File jarFile;

    public LibraryByJavaVersion(int javaVersion, File jarFile) {
        this.javaVersion = javaVersion;
        this.libraryName = LibraryByJavaVersion.libraryNameFromJarFileName(jarFile);
        this.jarFile = jarFile;
    }

    public int getJavaVersion() {
        return this.javaVersion;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public static List<File> resolveJvmDependantLibs(int javaVersionToFilter, Collection<LibraryByJavaVersion> libsByJavaVersion) {
        return libsByJavaVersion.stream().filter(l -> javaVersionToFilter >= l.getJavaVersion()).sorted((l1, l2) -> {
            if (l1.getLibraryName().compareTo(l2.getLibraryName()) == 0) {
                return l1.javaVersion - l2.javaVersion;
            }
            return l1.getLibraryName().compareTo(l2.getLibraryName());
        }).collect(Collectors.toMap(LibraryByJavaVersion::getLibraryName, UnaryOperator.identity(), (v1, v2) -> v2)).values().stream().map(LibraryByJavaVersion::getJarFile).collect(Collectors.toList());
    }

    private static String libraryNameFromJarFileName(File libFile) {
        String fn = libFile.getName();
        String name = fn.substring(0, fn.length() - 4);
        Matcher matcher = DASH_VERSION.matcher(name);
        if (matcher.find()) {
            name = name.substring(0, matcher.start());
        }
        return LibraryByJavaVersion.cleanModuleName(name);
    }

    private static String cleanModuleName(String mn) {
        int len;
        mn = NON_ALPHANUM.matcher(mn).replaceAll(".");
        if (!(mn = REPEATING_DOTS.matcher(mn).replaceAll(".")).isEmpty() && mn.charAt(0) == '.') {
            mn = LEADING_DOTS.matcher(mn).replaceAll("");
        }
        if ((len = mn.length()) > 0 && mn.charAt(len - 1) == '.') {
            mn = TRAILING_DOTS.matcher(mn).replaceAll("");
        }
        return mn;
    }
}

