/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata.descriptor;

import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;

public final class ParameterMetadataDescriptor {
    private final String name;
    private final MetadataType type;
    private final boolean isDynamic;

    private ParameterMetadataDescriptor(String name, MetadataType type, boolean isDynamic) {
        this.name = name;
        this.type = type;
        this.isDynamic = isDynamic;
    }

    public static ParameterMetadataDescriptorBuilder builder(String name) {
        return new ParameterMetadataDescriptorBuilder(name);
    }

    public String getName() {
        return this.name;
    }

    public MetadataType getType() {
        return this.type;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public static class ParameterMetadataDescriptorBuilder {
        private final String name;
        private MetadataType type;
        private boolean isDynamic = false;

        private ParameterMetadataDescriptorBuilder(String name) {
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("Name parameter cannot be blank for ParameterMetadataDescriptor");
            }
            this.name = name;
        }

        public ParameterMetadataDescriptorBuilder withType(MetadataType type) {
            this.type = type;
            return this;
        }

        public ParameterMetadataDescriptorBuilder dynamic(boolean isDynamic) {
            this.isDynamic = isDynamic;
            return this;
        }

        public ParameterMetadataDescriptor build() {
            if (this.type == null) {
                throw new IllegalArgumentException("Type parameter cannot be null for ParameterMetadataDescriptor");
            }
            return new ParameterMetadataDescriptor(this.name, this.type, this.isDynamic);
        }
    }
}

