/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.cookie;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class RFC2616DateParser
extends SimpleDateFormat {
    private final SimpleDateFormat format1 = new RFC2616DateParserObsolete1();
    private final SimpleDateFormat format2 = new RFC2616DateParserObsolete2();
    private static final ThreadLocal<RFC2616DateParser> DATE_FORMAT_HOLDER = new ThreadLocal<RFC2616DateParser>(){

        @Override
        protected RFC2616DateParser initialValue() {
            return new RFC2616DateParser();
        }
    };

    public static RFC2616DateParser get() {
        return DATE_FORMAT_HOLDER.get();
    }

    private RFC2616DateParser() {
        super("E, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
        this.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        Date date = super.parse(text, pos);
        if (date == null) {
            date = this.format1.parse(text, pos);
        }
        if (date == null) {
            date = this.format2.parse(text, pos);
        }
        return date;
    }

    private static final class RFC2616DateParserObsolete1
    extends SimpleDateFormat {
        private static final long serialVersionUID = -3178072504225114298L;

        RFC2616DateParserObsolete1() {
            super("E, dd-MMM-yy HH:mm:ss z", Locale.ENGLISH);
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    private static final class RFC2616DateParserObsolete2
    extends SimpleDateFormat {
        private static final long serialVersionUID = 3010674519968303714L;

        RFC2616DateParserObsolete2() {
            super("E MMM d HH:mm:ss yyyy", Locale.ENGLISH);
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }
}

