/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.jackson.JArrayNode;
import org.raml.yagi.framework.nodes.jackson.JBooleanNode;
import org.raml.yagi.framework.nodes.jackson.JFloatingNode;
import org.raml.yagi.framework.nodes.jackson.JIntegerNode;
import org.raml.yagi.framework.nodes.jackson.JNullNode;
import org.raml.yagi.framework.nodes.jackson.JObjectNode;
import org.raml.yagi.framework.nodes.jackson.JStringNode;

public class JModelWrapper {
    private ResourceLoader resourceLoader;
    private String resourcePath;

    public JModelWrapper(ResourceLoader resourceLoader, String resourcePath) {
        this.resourceLoader = resourceLoader;
        this.resourcePath = resourcePath;
    }

    public Node wrap(JsonNode node) {
        switch (node.getNodeType()) {
            case ARRAY: {
                return this.wrap((ArrayNode)node);
            }
            case OBJECT: {
                return this.wrap((ObjectNode)node);
            }
            case BOOLEAN: {
                return this.wrap((BooleanNode)node);
            }
            case NULL: {
                return this.wrap((NullNode)node);
            }
            case NUMBER: {
                if (node instanceof IntNode) {
                    return this.wrap((IntNode)node);
                }
                return this.wrap((NumericNode)node);
            }
            case STRING: {
                return this.wrap((TextNode)node);
            }
        }
        return null;
    }

    private JObjectNode wrap(ObjectNode objectNode) {
        JObjectNode object = new JObjectNode(objectNode, this.resourcePath, this.resourceLoader);
        Iterator fields = objectNode.fields();
        while (fields.hasNext()) {
            Map.Entry node = (Map.Entry)fields.next();
            JStringNode key = this.wrap(new TextNode((String)node.getKey()));
            Node value = this.wrap((JsonNode)node.getValue());
            KeyValueNodeImpl keyValue = new KeyValueNodeImpl(key, value);
            object.addChild(keyValue);
        }
        return object;
    }

    private JArrayNode wrap(ArrayNode arrayNode) {
        JArrayNode array = new JArrayNode(arrayNode, this.resourcePath, this.resourceLoader);
        for (JsonNode node : arrayNode) {
            array.addChild(this.wrap(node));
        }
        return array;
    }

    private JStringNode wrap(TextNode stringNode) {
        return new JStringNode(stringNode, this.resourcePath, this.resourceLoader);
    }

    private JIntegerNode wrap(IntNode integerNode) {
        return new JIntegerNode(integerNode, this.resourcePath, this.resourceLoader);
    }

    private JFloatingNode wrap(NumericNode numericNode) {
        return new JFloatingNode(numericNode, this.resourcePath, this.resourceLoader);
    }

    private JNullNode wrap(NullNode nullNode) {
        return new JNullNode(nullNode, this.resourcePath, this.resourceLoader);
    }

    private JBooleanNode wrap(BooleanNode booleanNode) {
        return new JBooleanNode(booleanNode, this.resourcePath, this.resourceLoader);
    }
}

