/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.context.notification;

import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationConfigurationChangeListener;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;

public final class OptimisedNotificationHandler
implements ServerNotificationHandler,
ServerNotificationConfigurationChangeListener {
    private ServerNotificationHandler delegate;
    private Class<? extends Notification> type;
    private boolean dynamic = false;
    private volatile Boolean enabled = null;
    private Class<? extends Notification> resolutionNotFnClass;

    public OptimisedNotificationHandler(ServerNotificationHandler delegate, Class<? extends Notification> type) {
        this(delegate, type, false);
    }

    public OptimisedNotificationHandler(ServerNotificationHandler delegate, Class<? extends Notification> type, boolean disableOptimisedNotificationHandlerDynamicResolutionUpdateBasedOnDelegate) {
        this.delegate = delegate;
        this.type = type;
        this.dynamic = delegate.isNotificationDynamic();
        if (!disableOptimisedNotificationHandlerDynamicResolutionUpdateBasedOnDelegate) {
            delegate.registerServerNotificationConfigurationChangeListener(this);
        }
    }

    @Override
    public boolean isNotificationDynamic() {
        return this.dynamic;
    }

    @Override
    public boolean isListenerRegistered(NotificationListener listener) {
        return this.delegate.isListenerRegistered(listener);
    }

    @Override
    public boolean isNotificationEnabled(Class<? extends Notification> notfnClass) {
        if (!this.dynamic && this.type.isAssignableFrom(notfnClass)) {
            if (this.enabled == null) {
                this.resolveEnabled(notfnClass);
            }
            return this.enabled;
        }
        return this.delegate.isNotificationEnabled(notfnClass);
    }

    private synchronized void resolveEnabled(Class<? extends Notification> notfnClass) {
        this.enabled = this.delegate.isNotificationEnabled(notfnClass);
        this.resolutionNotFnClass = notfnClass;
    }

    @Override
    public void fireNotification(Notification notification) {
        if (this.isNotificationEnabled(notification.getClass())) {
            this.delegate.fireNotification(notification);
        }
    }

    @Override
    public synchronized void onServerNotificationConfigurationChange() {
        if (this.resolutionNotFnClass != null) {
            this.enabled = this.delegate.isNotificationEnabled(this.resolutionNotFnClass);
        }
    }
}

