/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.core.proxy;

import java.lang.reflect.Type;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.togglz.core.Feature;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.LazyResolvingFeatureManager;
import org.togglz.core.proxy.TogglzSwitchable;

public class ByteBuddyProxyFactory {
    private static final Log log = LogFactory.getLog(ByteBuddyProxyFactory.class);

    public static <T> T passiveProxyFor(Feature feature, Class<? super T> interfaceClass, T active, T inactive) {
        return ByteBuddyProxyFactory.generateProxy(feature, interfaceClass, active, inactive, new LazyResolvingFeatureManager(), true);
    }

    public static <T> T passiveProxyFor(Feature feature, Class<? super T> interfaceClass, T active, T inactive, FeatureManager featureManager) {
        return ByteBuddyProxyFactory.generateProxy(feature, interfaceClass, active, inactive, featureManager, true);
    }

    public static <T> T proxyFor(Feature feature, Class<? super T> interfaceClass, T active, T inactive) {
        return ByteBuddyProxyFactory.generateProxy(feature, interfaceClass, active, inactive, new LazyResolvingFeatureManager(), false);
    }

    public static <T> T proxyFor(Feature feature, Class<? super T> interfaceClass, T active, T inactive, FeatureManager featureManager) {
        return ByteBuddyProxyFactory.generateProxy(feature, interfaceClass, active, inactive, featureManager, false);
    }

    private static <T> T generateProxy(Feature feature, Class<? super T> interfaceClass, T active, T inactive, FeatureManager featureManager, boolean passiveProxy) {
        try {
            Class<?> clazz = ByteBuddyProxyFactory.generateProxyClass(interfaceClass, passiveProxy);
            return (T)clazz.getConstructors()[0].newInstance(featureManager, feature, active, inactive);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create proxy for " + interfaceClass.getSimpleName(), e);
        }
    }

    private static Class<?> generateProxyClass(Class<?> interfaceClass, boolean passiveProxy) {
        Implementation.Composable activeProxyImpl = MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"checkTogglzState")).onSuper().andThen((Implementation.Composable)MethodCall.invokeSelf().onField("delegate"));
        MethodCall passiveProxyImpl = MethodCall.invokeSelf().onField("delegate");
        Class clazz = new ByteBuddy().with((NamingStrategy)new NamingStrategy.SuffixingRandom("togglz", (NamingStrategy.SuffixingRandom.BaseNameResolver)new NamingStrategy.SuffixingRandom.BaseNameResolver.ForGivenType(TypeDescription.ForLoadedType.of(interfaceClass)))).subclass((TypeDefinition)TypeDescription.Generic.Builder.parameterizedType(TogglzSwitchable.class, (Type[])new Type[]{interfaceClass}).build()).implement(new Type[]{interfaceClass}).method((ElementMatcher)ElementMatchers.isDeclaredBy(interfaceClass).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isDefaultMethod())).or((ElementMatcher)ElementMatchers.named((String)"toString"))).intercept((Implementation)(passiveProxy ? passiveProxyImpl : activeProxyImpl)).make().load(Thread.currentThread().getContextClassLoader()).getLoaded();
        if (log.isDebugEnabled()) {
            log.debug("Generated class " + clazz.getName() + " implements " + interfaceClass.getSimpleName());
        }
        return clazz;
    }
}

