/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.ConnectionCustomizer;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.FullQueryConnectionTester;
import com.mchange.v2.c3p0.impl.AbstractC3P0PooledConnection;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.IsValidSimplifiedConnectionTestPath;
import com.mchange.v2.c3p0.impl.NewProxyConnection;
import com.mchange.v2.c3p0.stmt.GooGooStatementCache;
import com.mchange.v2.c3p0.util.ConnectionEventSupport;
import com.mchange.v2.c3p0.util.StatementEventSupport;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.ConnectionEventListener;
import javax.sql.StatementEventListener;

public final class NewPooledConnection
extends AbstractC3P0PooledConnection {
    private static final MLogger logger = MLog.getLogger(NewPooledConnection.class);
    private static final SQLException NORMAL_CLOSE_PLACEHOLDER = new SQLException("This pooled Connection was explicitly close()ed by a client, not invalidated due to an error.");
    static Set holdabilityBugKeys = null;
    final Connection physicalConnection;
    final ConnectionTester connectionTester;
    final int connectionIsValidTimeout;
    final boolean autoCommitOnClose;
    final boolean forceIgnoreUnresolvedTransactions;
    final String preferredTestQuery;
    final boolean supports_setHoldability;
    final boolean supports_setReadOnly;
    final boolean supports_setTypeMap;
    final int dflt_txn_isolation;
    final String dflt_catalog;
    final int dflt_holdability;
    final boolean dflt_readOnly;
    final Map dflt_typeMap;
    final ConnectionEventSupport ces;
    final StatementEventSupport ses;
    GooGooStatementCache scache = null;
    Throwable invalidatingException = null;
    int connection_status = 0;
    Set uncachedActiveStatements = new HashSet();
    Map resultSetsForStatements = new HashMap();
    Set metaDataResultSets = new HashSet();
    Set rawConnectionResultSets = null;
    boolean connection_error_signaled = false;
    volatile NewProxyConnection exposedProxy = null;
    volatile boolean isolation_lvl_nondefault = false;
    volatile boolean catalog_nondefault = false;
    volatile boolean holdability_nondefault = false;
    volatile boolean readOnly_nondefault = false;
    volatile boolean typeMap_nondefault = false;

    public NewPooledConnection(Connection connection, ConnectionTester connectionTester, int n, boolean bl, boolean bl2, String string, ConnectionCustomizer connectionCustomizer, String string2) throws SQLException {
        try {
            if (connectionCustomizer != null) {
                connectionCustomizer.onAcquire(connection, string2);
            }
        }
        catch (Exception exception) {
            throw SqlUtils.toSQLException((Throwable)exception);
        }
        this.physicalConnection = connection;
        this.connectionTester = connectionTester;
        this.connectionIsValidTimeout = n;
        this.autoCommitOnClose = bl;
        this.forceIgnoreUnresolvedTransactions = bl2;
        this.preferredTestQuery = string;
        this.supports_setHoldability = C3P0ImplUtils.supportsMethod(connection, "setHoldability", new Class[]{Integer.TYPE});
        this.supports_setReadOnly = C3P0ImplUtils.supportsMethod(connection, "setReadOnly", new Class[]{Boolean.TYPE});
        this.supports_setTypeMap = C3P0ImplUtils.supportsMethod(connection, "setTypeMap", new Class[]{Map.class});
        this.dflt_txn_isolation = connection.getTransactionIsolation();
        this.dflt_catalog = connection.getCatalog();
        this.dflt_holdability = this.supports_setHoldability ? NewPooledConnection.carefulCheckHoldability(connection) : 2;
        this.dflt_readOnly = this.supports_setReadOnly ? NewPooledConnection.carefulCheckReadOnly(connection) : false;
        this.dflt_typeMap = this.supports_setTypeMap && NewPooledConnection.carefulCheckTypeMap(connection) == null ? null : Collections.EMPTY_MAP;
        this.ces = new ConnectionEventSupport(this);
        this.ses = new StatementEventSupport(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int carefulCheckHoldability(Connection connection) {
        try {
            return connection.getHoldability();
        }
        catch (Exception exception) {
            return 2;
        }
        catch (Error error) {
            Class<NewPooledConnection> clazz = NewPooledConnection.class;
            synchronized (NewPooledConnection.class) {
                String string;
                if (holdabilityBugKeys == null) {
                    holdabilityBugKeys = new HashSet();
                }
                if (!holdabilityBugKeys.contains(string = NewPooledConnection.holdabilityBugKey(connection, error))) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, connection + " threw an Error when we tried to check its default holdability. This is probably due to a bug in your JDBC driver that c3p0 can harmlessly work around (reported for some DB2 drivers). Please verify that the error stack trace is consistentwith the getHoldability() method not being properly implemented, and is not due to some deeper problem. This message will not be repeated for Connections of type " + connection.getClass().getName() + " that provoke errors of type " + error.getClass().getName() + " when getHoldability() is called.", (Throwable)error);
                    }
                    holdabilityBugKeys.add(string);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return 2;
            }
        }
    }

    private static String holdabilityBugKey(Connection connection, Error error) {
        return connection.getClass().getName() + '|' + error.getClass().getName();
    }

    private static boolean carefulCheckReadOnly(Connection connection) {
        try {
            return connection.isReadOnly();
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static Map carefulCheckTypeMap(Connection connection) {
        try {
            return connection.getTypeMap();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        try {
            if (this.exposedProxy == null) {
                this.exposedProxy = new NewProxyConnection(this.physicalConnection, this);
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "c3p0 -- Uh oh... getConnection() was called on a PooledConnection when it had already provided a client with a Connection that has not yet been closed. This probably indicates a bug in the connection pool!!!");
            }
            return this.exposedProxy;
        }
        catch (Exception exception) {
            SQLException sQLException = this.handleThrowable(exception);
            throw sQLException;
        }
    }

    public synchronized int getConnectionStatus() {
        return this.connection_status;
    }

    public synchronized void closeAll() throws SQLException {
        try {
            this.closeAllCachedStatements();
        }
        catch (Exception exception) {
            SQLException sQLException = this.handleThrowable(exception);
            throw sQLException;
        }
    }

    @Override
    synchronized void closeMaybeCheckedOut(boolean bl) throws SQLException {
        this.close(null, bl);
    }

    @Override
    public synchronized void close() throws SQLException {
        this.close(null);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.addConnectionEventListener(connectionEventListener);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.ces.removeConnectionEventListener(connectionEventListener);
    }

    public void printConnectionListeners() {
        this.ces.printListeners();
    }

    @Override
    public void addStatementEventListener(StatementEventListener statementEventListener) {
        if (logger.isLoggable(MLevel.INFO)) {
            logger.info("Per the JDBC4 spec, " + this.getClass().getName() + " accepts StatementListeners, but for now there is no circumstance under which they are notified!");
        }
        this.ses.addStatementEventListener(statementEventListener);
    }

    @Override
    public void removeStatementEventListener(StatementEventListener statementEventListener) {
        this.ses.removeStatementEventListener(statementEventListener);
    }

    public void printStatementListeners() {
        this.ses.printListeners();
    }

    @Override
    public synchronized void initStatementCache(GooGooStatementCache gooGooStatementCache) {
        this.scache = gooGooStatementCache;
    }

    public synchronized GooGooStatementCache getStatementCache() {
        return this.scache;
    }

    void markNewTxnIsolation(int n) {
        this.isolation_lvl_nondefault = n != this.dflt_txn_isolation;
    }

    void markNewCatalog(String string) {
        this.catalog_nondefault = ObjectUtils.eqOrBothNull((Object)string, (Object)this.dflt_catalog);
    }

    void markNewHoldability(int n) {
        this.holdability_nondefault = n != this.dflt_holdability;
    }

    void markNewReadOnly(boolean bl) {
        this.readOnly_nondefault = bl != this.dflt_readOnly;
    }

    void markNewTypeMap(Map map) {
        this.typeMap_nondefault = map != this.dflt_typeMap;
    }

    synchronized Object checkoutStatement(Method method, Object[] objectArray) throws SQLException {
        return this.scache.checkoutStatement(this.physicalConnection, method, objectArray);
    }

    synchronized void checkinStatement(Statement statement) throws SQLException {
        this.cleanupStatementResultSets(statement);
        this.scache.checkinStatement(statement);
    }

    synchronized void markActiveUncachedStatement(Statement statement) {
        this.uncachedActiveStatements.add(statement);
    }

    synchronized void markInactiveUncachedStatement(Statement statement) {
        this.cleanupStatementResultSets(statement);
        this.uncachedActiveStatements.remove(statement);
    }

    synchronized void markActiveResultSetForStatement(Statement statement, ResultSet resultSet) {
        Set set = this.resultSets(statement, true);
        set.add(resultSet);
    }

    synchronized void markInactiveResultSetForStatement(Statement statement, ResultSet resultSet) {
        Set set = this.resultSets(statement, false);
        if (set == null) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("ResultSet " + resultSet + " was apparently closed after the Statement that created it had already been closed.");
            }
        } else if (!set.remove(resultSet)) {
            throw new InternalError("Marking a ResultSet inactive that we did not know was opened!");
        }
    }

    synchronized void markActiveRawConnectionResultSet(ResultSet resultSet) {
        if (this.rawConnectionResultSets == null) {
            this.rawConnectionResultSets = new HashSet();
        }
        this.rawConnectionResultSets.add(resultSet);
    }

    synchronized void markInactiveRawConnectionResultSet(ResultSet resultSet) {
        if (!this.rawConnectionResultSets.remove(resultSet)) {
            throw new InternalError("Marking a raw Connection ResultSet inactive that we did not know was opened!");
        }
    }

    synchronized void markActiveMetaDataResultSet(ResultSet resultSet) {
        this.metaDataResultSets.add(resultSet);
    }

    synchronized void markInactiveMetaDataResultSet(ResultSet resultSet) {
        this.metaDataResultSets.remove(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markClosedProxyConnection(NewProxyConnection newProxyConnection, boolean bl) {
        SQLException sQLException = null;
        try {
            NewPooledConnection newPooledConnection = this;
            synchronized (newPooledConnection) {
                try {
                    if (newProxyConnection != this.exposedProxy) {
                        throw new InternalError("C3P0 Error: An exposed proxy asked a PooledConnection that was not its parents to clean up its resources!");
                    }
                    this.exposedProxy = null;
                    LinkedList linkedList = new LinkedList();
                    this.cleanupResultSets(linkedList);
                    this.cleanupUncachedStatements(linkedList);
                    this.checkinAllCachedStatements(linkedList);
                    if (linkedList.size() > 0) {
                        if (logger.isLoggable(MLevel.INFO)) {
                            logger.info("[c3p0] The following Exceptions occurred while trying to clean up a Connection's stranded resources:");
                        }
                        for (Throwable throwable : linkedList) {
                            if (!logger.isLoggable(MLevel.INFO)) continue;
                            logger.log(MLevel.INFO, "[c3p0 -- connection resource close Exception]", throwable);
                        }
                    }
                    this.reset(bl);
                    if (linkedList.size() > 0) {
                        sQLException = SqlUtils.toSQLException((Throwable)((Throwable)linkedList.get(0)));
                    }
                }
                catch (SQLException sQLException2) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "An exception occurred while reseting a closed Connection. Invalidating Connection.", (Throwable)sQLException2);
                    }
                    this.updateConnectionStatus(-1);
                    sQLException = sQLException2;
                }
            }
            if (sQLException != null) {
                this.fireConnectionErrorOccurred(sQLException);
            }
            this.fireConnectionClosed();
        }
        catch (Throwable throwable) {
            if (sQLException != null) {
                this.fireConnectionErrorOccurred(sQLException);
            }
            this.fireConnectionClosed();
            throw throwable;
        }
    }

    private void reset(boolean bl) throws SQLException {
        C3P0ImplUtils.resetTxnState(this.physicalConnection, this.forceIgnoreUnresolvedTransactions, this.autoCommitOnClose, bl);
        if (this.isolation_lvl_nondefault) {
            this.physicalConnection.setTransactionIsolation(this.dflt_txn_isolation);
            this.isolation_lvl_nondefault = false;
        }
        if (this.catalog_nondefault) {
            this.physicalConnection.setCatalog(this.dflt_catalog);
            this.catalog_nondefault = false;
        }
        if (this.holdability_nondefault) {
            this.physicalConnection.setHoldability(this.dflt_holdability);
            this.holdability_nondefault = false;
        }
        if (this.readOnly_nondefault) {
            this.physicalConnection.setReadOnly(this.dflt_readOnly);
            this.readOnly_nondefault = false;
        }
        if (this.typeMap_nondefault) {
            this.physicalConnection.setTypeMap(this.dflt_typeMap);
            this.typeMap_nondefault = false;
        }
    }

    synchronized boolean isStatementCaching() {
        return this.scache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLException handleThrowable(Throwable throwable) {
        boolean bl = false;
        SQLException sQLException = null;
        try {
            NewPooledConnection newPooledConnection = this;
            synchronized (newPooledConnection) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, this + " handling a throwable.", throwable);
                }
                sQLException = SqlUtils.toSQLException((Throwable)throwable);
                int n = this.connectionTester == null ? IsValidSimplifiedConnectionTestPath.isValidTestConnectionForStatusOnly(this.physicalConnection, this.connectionIsValidTimeout) : (this.connectionTester instanceof FullQueryConnectionTester ? ((FullQueryConnectionTester)this.connectionTester).statusOnException(this.physicalConnection, sQLException, this.preferredTestQuery) : this.connectionTester.statusOnException(this.physicalConnection, sQLException));
                this.updateConnectionStatus(n);
                if (n != 0) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, this + " invalidated by Exception.", throwable);
                    }
                    if (!this.connection_error_signaled) {
                        bl = true;
                    } else if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "[c3p0] A PooledConnection that has already signalled a Connection error is still in use!");
                        logger.log(MLevel.FINE, "[c3p0] Another error has occurred [ " + throwable + " ] which will not be reported to listeners!", throwable);
                    }
                }
            }
            if (bl) {
                this.fireConnectionErrorOccurred(sQLException);
                this.connection_error_signaled = true;
            }
        }
        catch (Throwable throwable2) {
            if (bl) {
                this.fireConnectionErrorOccurred(sQLException);
                this.connection_error_signaled = true;
            }
            throw throwable2;
        }
        return sQLException;
    }

    private void fireConnectionClosed() {
        assert (!Thread.holdsLock(this));
        this.ces.fireConnectionClosed();
    }

    private void fireConnectionErrorOccurred(SQLException sQLException) {
        assert (!Thread.holdsLock(this));
        this.ces.fireConnectionErrorOccurred(sQLException);
    }

    private void close(Throwable throwable) throws SQLException {
        this.close(throwable, false);
    }

    private void close(Throwable throwable, boolean bl) throws SQLException {
        assert (Thread.holdsLock(this));
        if (this.invalidatingException == null) {
            LinkedList<SQLException> linkedList;
            block15: {
                linkedList = new LinkedList<SQLException>();
                this.cleanupResultSets(linkedList);
                this.cleanupUncachedStatements(linkedList);
                try {
                    this.closeAllCachedStatements();
                }
                catch (SQLException sQLException) {
                    linkedList.add(sQLException);
                }
                if (bl) {
                    try {
                        C3P0ImplUtils.resetTxnState(this.physicalConnection, this.forceIgnoreUnresolvedTransactions, this.autoCommitOnClose, false);
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.FINER)) break block15;
                        logger.log(MLevel.FINER, "Failed to reset the transaction state of  " + this.physicalConnection + "just prior to close(). Only relevant at all if this was a Connection being forced close()ed midtransaction.", (Throwable)exception);
                    }
                }
            }
            try {
                this.physicalConnection.close();
            }
            catch (SQLException sQLException) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Failed to close physical Connection: " + this.physicalConnection, (Throwable)sQLException);
                }
                linkedList.add(sQLException);
            }
            if (this.connection_status == 0) {
                this.connection_status = -1;
            }
            if (throwable == null) {
                this.invalidatingException = NORMAL_CLOSE_PLACEHOLDER;
                if (logger.isLoggable(MLevel.FINEST)) {
                    logger.log(MLevel.FINEST, this + " closed by a client.", (Throwable)new Exception("DEBUG -- CLOSE BY CLIENT STACK TRACE"));
                }
                NewPooledConnection.logCloseExceptions(null, linkedList);
                if (linkedList.size() > 0) {
                    throw new SQLException("Some resources failed to close properly while closing " + this);
                }
            } else {
                this.invalidatingException = throwable;
                NewPooledConnection.logCloseExceptions(throwable, linkedList);
            }
        }
    }

    private void cleanupResultSets(List list) {
        this.cleanupAllStatementResultSets(list);
        this.cleanupUnclosedResultSetsSet(this.metaDataResultSets, list);
        if (this.rawConnectionResultSets != null) {
            this.cleanupUnclosedResultSetsSet(this.rawConnectionResultSets, list);
        }
    }

    private void cleanupUnclosedResultSetsSet(Set set, List list) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ResultSet resultSet = (ResultSet)iterator.next();
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                list.add(sQLException);
            }
            iterator.remove();
        }
    }

    private void cleanupStatementResultSets(Statement statement) {
        Set set = this.resultSets(statement, false);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    ((ResultSet)iterator.next()).close();
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(MLevel.INFO)) continue;
                    logger.log(MLevel.INFO, "ResultSet close() failed.", (Throwable)exception);
                }
            }
        }
        this.resultSetsForStatements.remove(statement);
    }

    private void cleanupAllStatementResultSets(List list) {
        for (Object k : this.resultSetsForStatements.keySet()) {
            Set set = (Set)this.resultSetsForStatements.get(k);
            for (ResultSet resultSet : set) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    list.add(sQLException);
                    if (!logger.isLoggable(MLevel.FINER)) continue;
                    logger.log(MLevel.FINER, "An Exception occurred while trying to cleanup the following ResultSet: " + resultSet, (Throwable)sQLException);
                }
            }
        }
        this.resultSetsForStatements.clear();
    }

    private void cleanupUncachedStatements(List list) {
        Iterator iterator = this.uncachedActiveStatements.iterator();
        while (iterator.hasNext()) {
            block3: {
                Statement statement = (Statement)iterator.next();
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    list.add(sQLException);
                    if (!logger.isLoggable(MLevel.FINER)) break block3;
                    logger.log(MLevel.FINER, "An Exception occurred while trying to cleanup the following uncached Statement: " + statement, (Throwable)sQLException);
                }
            }
            iterator.remove();
        }
    }

    private void checkinAllCachedStatements(List list) {
        try {
            if (this.scache != null) {
                this.scache.checkinAll(this.physicalConnection);
            }
        }
        catch (SQLException sQLException) {
            list.add(sQLException);
        }
    }

    private void closeAllCachedStatements() throws SQLException {
        if (this.scache != null) {
            this.scache.closeAll(this.physicalConnection);
        }
    }

    private void updateConnectionStatus(int n) {
        switch (this.connection_status) {
            case -8: {
                break;
            }
            case -1: {
                if (n != -8) break;
                this.connection_status = n;
                break;
            }
            case 0: {
                if (n == 0) break;
                this.connection_status = n;
                break;
            }
            default: {
                throw new InternalError(this + " -- Illegal Connection Status: " + this.connection_status);
            }
        }
    }

    private Set resultSets(Statement statement, boolean bl) {
        HashSet hashSet = (HashSet)this.resultSetsForStatements.get(statement);
        if (hashSet == null && bl) {
            hashSet = new HashSet();
            this.resultSetsForStatements.put(statement, hashSet);
        }
        return hashSet;
    }

    @Override
    Connection getPhysicalConnection() {
        return this.physicalConnection;
    }

    private static void logCloseExceptions(Throwable throwable, Collection collection) {
        if (logger.isLoggable(MLevel.INFO)) {
            if (throwable != null) {
                logger.log(MLevel.INFO, "[c3p0] A PooledConnection died due to the following error!", throwable);
            }
            if (collection != null && collection.size() > 0) {
                if (throwable == null) {
                    logger.info("[c3p0] Exceptions occurred while trying to close a PooledConnection's resources normally.");
                } else {
                    logger.info("[c3p0] Exceptions occurred while trying to close a Broken PooledConnection.");
                }
                for (Throwable throwable2 : collection) {
                    logger.log(MLevel.INFO, "[c3p0] NewPooledConnection close Exception.", throwable2);
                }
            }
        }
    }
}

