/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public final class ExpressionLanguageUtils {
    private static final BindingContext COMPILATION_BINDING_CONTEXT = BindingContextUtils.addFlowNameBindingsToBuilder((ComponentLocation)DefaultComponentLocation.from((String)"(null)"), (BindingContext.Builder)BindingContextUtils.addEventBuindingsToBuilder((Event)NullEventFactory.getNullEvent(), (BindingContext)BindingContextUtils.NULL_BINDING_CONTEXT)).build();

    private ExpressionLanguageUtils() {
    }

    public static CompiledExpression compile(String expression, ExpressionLanguage expressionLanguage) {
        return expressionLanguage.compile(expression, COMPILATION_BINDING_CONTEXT);
    }

    public static String sanitize(String expression) {
        String sanitizedExpression;
        if (expression.startsWith("#[")) {
            if (!expression.endsWith("]")) {
                throw new ExpressionExecutionException(I18nMessageFactory.createStaticMessage((String)String.format("Unbalanced brackets in expression '%s'", expression)));
            }
            sanitizedExpression = expression.substring("#[".length(), expression.length() - "]".length());
        } else {
            sanitizedExpression = expression;
        }
        return sanitizedExpression;
    }

    public static boolean isSanitizedPayload(String expression) {
        return "payload".equals(expression);
    }
}

