/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.elab;

import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.OptionalItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.elab.SingleItemEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.Cardinality;

public abstract class ItemElaborator
extends Elaborator {
    @Override
    public SequenceEvaluator eagerly() {
        boolean maybeEmpty = Cardinality.allowsZero(this.getExpression().getCardinality());
        ItemEvaluator ie = this.elaborateForItem();
        if (maybeEmpty) {
            return new OptionalItemEvaluator(ie);
        }
        return new SingleItemEvaluator(ie);
    }

    @Override
    public PullEvaluator elaborateForPull() {
        ItemEvaluator ie = this.elaborateForItem();
        return context -> SingletonIterator.makeIterator(ie.eval(context));
    }

    @Override
    public PushEvaluator elaborateForPush() {
        ItemEvaluator ie = this.elaborateForItem();
        return (out, context) -> {
            Item it = ie.eval(context);
            if (it != null) {
                out.append(it);
            }
            return null;
        };
    }

    @Override
    public abstract ItemEvaluator elaborateForItem();

    @Override
    public BooleanEvaluator elaborateForBoolean() {
        ItemEvaluator ie = this.elaborateForItem();
        return context -> ExpressionTool.effectiveBooleanValue(ie.eval(context));
    }

    @Override
    public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
        ItemEvaluator ie = this.elaborateForItem();
        return context -> {
            Item item = ie.eval(context);
            return item == null ? this.handleNullUnicodeString(zeroLengthWhenAbsent) : item.getUnicodeStringValue();
        };
    }
}

