/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.extension.incubator.logs.KeyAnyValue;
import io.opentelemetry.proto.common.v1.internal.AnyValue;
import io.opentelemetry.proto.common.v1.internal.KeyValueList;
import java.io.IOException;
import java.util.List;

final class KeyValueListAnyValueMarshaler
extends MarshalerWithSize {
    private final Marshaler value;

    private KeyValueListAnyValueMarshaler(KeyValueListMarshaler value) {
        super(KeyValueListAnyValueMarshaler.calculateSize((Marshaler)value));
        this.value = value;
    }

    static MarshalerWithSize create(List<KeyAnyValue> values) {
        int len = values.size();
        KeyValueMarshaler[] marshalers = new KeyValueMarshaler[values.size()];
        for (int i = 0; i < len; ++i) {
            marshalers[i] = KeyValueMarshaler.createForKeyAnyValue(values.get(i));
        }
        return new KeyValueListAnyValueMarshaler(new KeyValueListMarshaler(marshalers));
    }

    public void writeTo(Serializer output) throws IOException {
        output.serializeMessage(AnyValue.KVLIST_VALUE, this.value);
    }

    private static int calculateSize(Marshaler value) {
        return MarshalerUtil.sizeMessage((ProtoFieldInfo)AnyValue.KVLIST_VALUE, (Marshaler)value);
    }

    private static class KeyValueListMarshaler
    extends MarshalerWithSize {
        private final Marshaler[] values;

        private KeyValueListMarshaler(KeyValueMarshaler[] values) {
            super(KeyValueListMarshaler.calculateSize((Marshaler[])values));
            this.values = values;
        }

        public void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(KeyValueList.VALUES, this.values);
        }

        private static int calculateSize(Marshaler[] values) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)KeyValueList.VALUES, (Marshaler[])values);
        }
    }
}

