/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.BaseResponseSender;

public class DirectResponseSender
extends BaseResponseSender {
    public DirectResponseSender(HttpRequest httpRequest, ChannelHandlerContext ctx, HttpResponse response, ResponseStatusCallback statusCallback) {
        super(httpRequest, ctx, response, statusCallback);
    }

    @Override
    protected void sendContent() throws IOException {
        InputStream contentAsInputStream = this.response.getEntity().getContent();
        ByteBuf content = this.inputStreamToByteBuf(contentAsInputStream);
        this.sendLastContentAndFinishStreaming(content, contentAsInputStream);
    }

    private ByteBuf inputStreamToByteBuf(InputStream inputStream) throws IOException {
        int availableBytes = inputStream.available();
        ByteBuf content = this.createBuffer(availableBytes);
        content.writeBytes(inputStream, availableBytes);
        return content;
    }
}

