/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.HttpServerFactory;
import org.mule.runtime.http.api.server.ServerAlreadyExistsException;
import org.mule.runtime.http.api.server.ServerCreationException;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.service.http.netty.impl.server.AcceptedConnectionChannelInitializer;
import org.mule.service.http.netty.impl.server.NettyHttpServer;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.server.util.HttpServerAdapter;

public class HttpServerConnectionManager
implements HttpServerFactory {
    private static final int SERVER_SELECTOR_THREAD_COUNT = Integer.getInteger("mule.http.server.selectors.count", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private final Map<String, HttpServer> servers = new ConcurrentHashMap<String, HttpServer>();
    private final SchedulerService schedulerService;

    public HttpServerConnectionManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    protected HttpServerConnectionManager() {
        this(null);
    }

    public HttpServer create(HttpServerConfiguration configuration) throws ServerCreationException {
        String name = configuration.getName();
        HttpServer alreadyPresent = this.servers.get(name);
        if (alreadyPresent != null) {
            throw new ServerAlreadyExistsException(alreadyPresent.getServerAddress());
        }
        HttpServer created = this.createServer(name, configuration);
        this.servers.putIfAbsent(name, created);
        return created;
    }

    public HttpServer lookup(String name) throws ServerNotFoundException {
        HttpServer server = this.servers.get(name);
        if (server == null) {
            throw new ServerNotFoundException(name);
        }
        return new NoLifecycleHttpServer(server);
    }

    public HttpServer getOrCreateServer(String name, Supplier<? extends HttpServerConfiguration> configuration) throws ServerCreationException {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Server name can't be null");
        try {
            return this.servers.computeIfAbsent(name, serverName -> this.createServer(name, (HttpServerConfiguration)configuration.get()));
        }
        catch (MuleRuntimeException e) {
            throw new ServerCreationException(e.getMessage(), (Throwable)e);
        }
    }

    protected HttpServer createServer(String name, HttpServerConfiguration configuration) throws MuleRuntimeException {
        try {
            Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Server name can't be null");
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"Server configuration can't be null");
            HttpListenerRegistry httpListenerRegistry = new HttpListenerRegistry();
            SslContext sslContext = this.createSslContext(configuration);
            Scheduler selectorsScheduler = this.createSelectorsScheduler();
            NettyHttpServer.Builder builder = NettyHttpServer.builder().withServerAddress(new InetSocketAddress(configuration.getHost(), configuration.getPort())).withHttpListenerRegistry(httpListenerRegistry).withSslContext(sslContext).withSelectorsScheduler(selectorsScheduler).withSelectorsCount(SERVER_SELECTOR_THREAD_COUNT).doOnDispose(() -> this.servers.remove(name));
            return this.enrichServerBuilder(builder, httpListenerRegistry, configuration, sslContext).build();
        }
        catch (IllegalArgumentException | KeyManagementException | NoSuchAlgorithmException | CertificateException | SSLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Scheduler createSelectorsScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(SERVER_SELECTOR_THREAD_COUNT).withName("http.listener"), 0);
    }

    protected NettyHttpServer.Builder enrichServerBuilder(NettyHttpServer.Builder builder, HttpListenerRegistry listenerRegistry, HttpServerConfiguration configuration, SslContext sslContext) {
        return builder.withClientChannelHandler(new AcceptedConnectionChannelInitializer(listenerRegistry, configuration, sslContext));
    }

    private SslContext createSslContext(HttpServerConfiguration configuration) throws SSLException, CertificateException, NoSuchAlgorithmException, KeyManagementException {
        TlsContextFactory tlsContextFactory = configuration.getTlsContextFactory();
        if (tlsContextFactory == null) {
            return null;
        }
        ClientAuth clientAuth = tlsContextFactory.isTrustStoreConfigured() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL;
        return new JdkSslContext(tlsContextFactory.createSslContext(), false, this.getCiphers(tlsContextFactory), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, new String[]{"http/1.1"}), clientAuth, tlsContextFactory.getEnabledProtocols(), false);
    }

    private Iterable<String> getCiphers(TlsContextFactory tlsContextFactory) {
        if (tlsContextFactory == null) {
            return null;
        }
        String[] enabledCipherSuites = tlsContextFactory.getEnabledCipherSuites();
        if (enabledCipherSuites == null) {
            return null;
        }
        return Arrays.asList(enabledCipherSuites);
    }

    private static class NoLifecycleHttpServer
    extends HttpServerAdapter {
        public NoLifecycleHttpServer(HttpServer delegate) {
            super(delegate);
        }

        @Override
        public HttpServer start() {
            return this;
        }

        @Override
        public HttpServer stop() {
            return this;
        }

        @Override
        public void dispose() {
        }
    }
}

