/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.StringElaborator;
import net.sf.saxon.expr.elab.StringEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class SubstringBefore
extends CollatingFunctionFixed {
    @Override
    public boolean isSubstringMatchingFunction() {
        return true;
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        UnicodeString s0 = this.getUniStringArg(arguments[0]);
        UnicodeString s1 = this.getUniStringArg(arguments[1]);
        StringCollator collator = this.getStringCollator();
        return new StringValue(((SubstringMatcher)collator).substringBefore(s0, s1));
    }

    @Override
    public Elaborator getElaborator() {
        return new SubstringBeforeFnElaborator();
    }

    public static class SubstringBeforeFnElaborator
    extends StringElaborator {
        @Override
        public UnicodeStringEvaluator elaborateForUnicodeString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            SubstringBefore fn = (SubstringBefore)fnc.getTargetFunction();
            SubstringMatcher stringCollator = (SubstringMatcher)fn.getStringCollator();
            assert (stringCollator != null);
            UnicodeStringEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForUnicodeString(true);
            UnicodeStringEvaluator arg1Eval = fnc.getArg(1).makeElaborator().elaborateForUnicodeString(true);
            if (stringCollator instanceof CodepointCollator) {
                return context -> {
                    UnicodeString s0 = arg0Eval.eval(context);
                    UnicodeString s1 = arg1Eval.eval(context);
                    if (s1.isEmpty()) {
                        return s1;
                    }
                    if (s0.isEmpty()) {
                        return EmptyUnicodeString.getInstance();
                    }
                    long j = s0.indexOf(s1, 0L);
                    if (j < 0L) {
                        return EmptyUnicodeString.getInstance();
                    }
                    return s0.prefix(j);
                };
            }
            return context -> {
                UnicodeString s0 = arg0Eval.eval(context);
                UnicodeString s1 = arg1Eval.eval(context);
                return stringCollator.substringBefore(s0, s1);
            };
        }

        @Override
        public StringEvaluator elaborateForString(boolean zeroLengthWhenAbsent) {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            SubstringBefore fn = (SubstringBefore)fnc.getTargetFunction();
            SubstringMatcher stringCollator = (SubstringMatcher)fn.getStringCollator();
            assert (stringCollator != null);
            if (stringCollator instanceof CodepointCollator) {
                StringEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForString(true);
                StringEvaluator arg1Eval = fnc.getArg(1).makeElaborator().elaborateForString(true);
                return context -> {
                    String s0 = arg0Eval.eval(context);
                    String s1 = arg1Eval.eval(context);
                    if (s1.isEmpty()) {
                        return s0;
                    }
                    if (s0.isEmpty()) {
                        return "";
                    }
                    int j = s0.indexOf(s1, 0);
                    if (j < 0) {
                        return "";
                    }
                    return s0.substring(0, j);
                };
            }
            return super.elaborateForString(zeroLengthWhenAbsent);
        }
    }
}

