/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.commons.lang3.math.NumberUtils;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.message.ds.ByteArrayDataSource;
import org.mule.runtime.core.api.message.ds.InputStreamDataSource;
import org.mule.runtime.core.api.message.ds.StringDataSource;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.NotAnInputStreamException;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.api.util.func.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    protected static int bufferSize = NumberUtils.toInt((String)System.getProperty("mule.streaming.bufferSize"), (int)4096);

    public static String getResourceAsString(String resourceName, Class callingClass) throws IOException {
        try (InputStream is = IOUtils.getResourceAsStream(resourceName, callingClass);){
            if (is != null) {
                String string = IOUtils.toString(is);
                return string;
            }
            throw new IOException("Unable to load resource " + resourceName);
        }
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) throws IOException {
        return IOUtils.getResourceAsStream(resourceName, callingClass, true, true);
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) throws IOException {
        URL url = IOUtils.getResourceAsUrl(resourceName, callingClass, tryAsFile, tryAsUrl);
        if (url == null) {
            return null;
        }
        return IOUtils.getInputStreamWithCacheControl(url);
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass) {
        return IOUtils.getResourceAsUrl(resourceName, callingClass, true, true);
    }

    public static URL getResourceAsUrl(String resourceName, Class callingClass, boolean tryAsFile, boolean tryAsUrl) {
        if (resourceName == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("Resource name").getMessage());
        }
        URL url = null;
        if (tryAsFile) {
            try {
                File file = FileUtils.newFile(resourceName);
                if (file.exists()) {
                    url = file.getAbsoluteFile().toURL();
                } else {
                    logger.debug("Unable to load resource from the file system: " + file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource from the file system: " + e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = (URL)AccessController.doPrivileged(() -> ClassUtils.getResource(resourceName, callingClass));
                if (url == null) {
                    logger.debug("Unable to load resource " + resourceName + " from the classpath");
                }
            }
            catch (Exception e) {
                logger.debug("Unable to load resource " + resourceName + " from the classpath: " + e.getMessage());
            }
        }
        if (url == null) {
            try {
                url = new URL(resourceName);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    public static InputStream getInputStreamWithCacheControl(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        if (urlConnection instanceof JarURLConnection) {
            urlConnection.setUseCaches(false);
        }
        return urlConnection.getInputStream();
    }

    public static String toString(InputStream input) {
        try {
            return org.apache.commons.io.IOUtils.toString((InputStream)input);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static String toString(InputStream input, Charset encoding) {
        try {
            return org.apache.commons.io.IOUtils.toString((InputStream)input, (Charset)encoding);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static String toString(InputStream input, String encoding) {
        try {
            return org.apache.commons.io.IOUtils.toString((InputStream)input, (String)encoding);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static String toString(CursorStreamProvider cursorStreamProvider) {
        String string;
        block8: {
            InputStream input = (InputStream)cursorStreamProvider.openCursor();
            try {
                string = org.apache.commons.io.IOUtils.toString((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iox) {
                    throw new RuntimeException(iox);
                }
            }
            input.close();
        }
        return string;
    }

    public static byte[] toByteArray(InputStream input) {
        try {
            return org.apache.commons.io.IOUtils.toByteArray((InputStream)input);
        }
        catch (IOException iox) {
            throw new RuntimeException(iox);
        }
    }

    public static byte[] toByteArray(CursorStreamProvider cursorStreamProvider) {
        byte[] byArray;
        block8: {
            InputStream input = (InputStream)cursorStreamProvider.openCursor();
            try {
                byArray = IOUtils.toByteArray(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return byArray;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        return IOUtils.copyLarge(input, output, bufferSize);
    }

    public static long copyLarge(Reader input, Writer output) throws IOException {
        char[] buffer = new char[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copyLarge(InputStream input, OutputStream output, int bufferSize) throws IOException {
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static DataHandler toDataHandler(String name, Object object, MediaType contentType) throws IOException {
        DataHandler dh = object instanceof File ? (contentType != null ? new DataHandler((Object)new FileInputStream((File)object), contentType.toString()) : new DataHandler((DataSource)new FileDataSource((File)object))) : (object instanceof URL ? (contentType != null ? new DataHandler((Object)((URL)object).openStream(), contentType.toString()) : new DataHandler((URL)object)) : (object instanceof String ? (contentType != null ? new DataHandler((DataSource)new StringDataSource((String)object, name, contentType)) : new DataHandler((DataSource)new StringDataSource((String)object, name))) : (object instanceof byte[] && contentType != null ? new DataHandler((DataSource)new ByteArrayDataSource((byte[])object, contentType, name)) : (object instanceof InputStream && contentType != null ? new DataHandler((DataSource)new InputStreamDataSource((InputStream)object, contentType, name)) : new DataHandler(object, contentType != null ? contentType.toString() : null)))));
        return dh;
    }

    public static void ifInputStream(Object value, CheckedConsumer<InputStream> consumer) throws NotAnInputStreamException {
        IOUtils.ifInputStream(value, (InputStream stream) -> {
            consumer.accept((InputStream)stream);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T ifInputStream(Object value, CheckedFunction<InputStream, T> function) throws NotAnInputStreamException {
        boolean shouldCloseStream = false;
        InputStream stream = null;
        if (value instanceof CursorStreamProvider) {
            stream = (InputStream)((CursorStreamProvider)value).openCursor();
            shouldCloseStream = true;
        } else if (value instanceof InputStream) {
            stream = (InputStream)value;
        } else {
            throw new NotAnInputStreamException(stream);
        }
        try {
            T t = function.apply(stream);
            return t;
        }
        finally {
            if (shouldCloseStream) {
                IOUtils.closeQuietly(stream);
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        org.apache.commons.io.IOUtils.closeQuietly((Closeable)closeable);
    }

    private IOUtils() {
    }
}

