/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution.compatibility;

import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.core.api.execution.ExecutionCallback;
import org.mule.runtime.core.api.transaction.Transaction;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.api.transaction.TransactionCoordination;
import org.mule.runtime.core.internal.execution.ExecutionContext;
import org.mule.runtime.core.internal.execution.ExecutionInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolvePreviousTransactionInterceptor<T>
implements ExecutionInterceptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(ResolvePreviousTransactionInterceptor.class);
    private final ExecutionInterceptor<T> next;
    private TransactionConfig transactionConfig;

    public ResolvePreviousTransactionInterceptor(ExecutionInterceptor<T> next, TransactionConfig transactionConfig) {
        this.next = next;
        this.transactionConfig = transactionConfig;
    }

    @Override
    public T execute(ExecutionCallback<T> callback, ExecutionContext executionContext) throws Exception {
        byte action = this.transactionConfig.getAction();
        Transaction transactionBeforeTemplate = TransactionCoordination.getInstance().getTransaction();
        if ((action == 0 || action == 1) && transactionBeforeTemplate != null) {
            if (logger.isDebugEnabled()) {
                logger.debug(action + ", current TX: " + transactionBeforeTemplate);
            }
            this.resolveTransaction();
        }
        return this.next.execute(callback, executionContext);
    }

    protected void resolveTransaction() throws TransactionException {
        TransactionCoordination.getInstance().resolveTransaction();
    }
}

