/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation.construct;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.module.extension.internal.runtime.operation.construct.MuleOperation;
import org.mule.runtime.module.extension.internal.runtime.operation.construct.Operation;

class DefaultOperationBuilder
implements Operation.Builder {
    private OperationModel operationModel;
    private MuleContext muleContext;
    private List<Processor> processors = Collections.emptyList();
    private MuleOperation product;

    DefaultOperationBuilder() {
    }

    @Override
    public Operation.Builder processors(List<Processor> processors) {
        this.checkImmutable();
        Preconditions.checkArgument((processors != null ? 1 : 0) != 0, (String)"processors cannot be null");
        this.processors = processors;
        return this;
    }

    @Override
    public Operation.Builder processors(Processor ... processors) {
        this.checkImmutable();
        this.processors = Arrays.asList(processors);
        return this;
    }

    @Override
    public Operation.Builder setOperationModel(OperationModel operationModel) {
        this.operationModel = operationModel;
        return this;
    }

    @Override
    public Operation.Builder setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        return this;
    }

    @Override
    public Operation build() {
        this.checkImmutable();
        this.checkInvoked(this.operationModel, "setOperationModel(OperationModel)");
        this.checkInvoked(this.muleContext, "setMuleContext(MuleContext)");
        Preconditions.checkState((this.processors != null && !this.processors.isEmpty() ? 1 : 0) != 0, (String)"Processors cannot be null nor empty");
        this.product = new MuleOperation(this.processors, this.operationModel, this.muleContext);
        return this.product;
    }

    private final void checkImmutable() {
        if (this.product != null) {
            throw new IllegalStateException("Cannot change attributes once the operation was built");
        }
    }

    private void checkInvoked(Object value, String methodName) {
        Preconditions.checkState((value != null ? 1 : 0) != 0, (String)(methodName + " not invoked"));
    }
}

