/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.URI;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.service.http.netty.impl.client.auth.AuthHeaderFactory;
import org.mule.service.http.netty.impl.client.auth.BasicAuthHeaderFactory;
import org.mule.service.http.netty.impl.client.auth.DigestAuthMessageFactory;
import org.mule.service.http.netty.impl.client.auth.ntlm.NtlmMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationEngine.class);
    private final HttpAuthenticationType type;
    private final AuthHeaderFactory authMessageFactory;

    public AuthenticationEngine(HttpAuthentication authentication, URI uri, String method) {
        this.type = authentication.getType();
        this.authMessageFactory = this.createAuthHeaderFactory(authentication, uri, method);
    }

    private AuthHeaderFactory createAuthHeaderFactory(HttpAuthentication authentication, URI uri, String method) {
        switch (this.type) {
            case BASIC: {
                return new BasicAuthHeaderFactory(authentication.isPreemptive(), authentication.getUsername(), authentication.getPassword());
            }
            case NTLM: {
                HttpAuthentication.HttpNtlmAuthentication ntlmAuthentication = (HttpAuthentication.HttpNtlmAuthentication)authentication;
                return new NtlmMessageFactory(ntlmAuthentication.getDomain(), ntlmAuthentication.getWorkstation(), authentication.getUsername(), authentication.getPassword());
            }
            case DIGEST: {
                return new DigestAuthMessageFactory(authentication.getUsername(), authentication.getPassword(), uri, method);
            }
        }
        throw new IllegalArgumentException("Unknown authentication type: " + this.type);
    }

    public String getNextHeader(String wwwAuthenticateHeader) throws Exception {
        return this.authMessageFactory.getNextHeader(wwwAuthenticateHeader);
    }

    public HttpHeaders getAuthHeaders(HttpHeaders currentHeaders) {
        DefaultHttpHeaders authHeaders = new DefaultHttpHeaders();
        String authHeader = this.computeAuthHeaders(currentHeaders.get("WWW-Authenticate"));
        if (authHeader != null) {
            authHeaders.add("Authorization", (Object)authHeader);
        }
        return authHeaders;
    }

    private String computeAuthHeaders(String wwwAuthenticateHeader) {
        try {
            return this.getNextHeader(wwwAuthenticateHeader);
        }
        catch (Exception e) {
            LOGGER.warn("Error while calculating {} Auth header", (Object)this.type, (Object)e);
            return null;
        }
    }

    public HttpAuthenticationType getType() {
        return this.type;
    }

    public boolean hasFinished() {
        return this.authMessageFactory.hasFinished();
    }
}

