/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import jcifs.CIFSContext;
import jcifs.context.SingletonContext;
import jcifs.ntlmssp.Type1Message;
import jcifs.ntlmssp.Type2Message;
import jcifs.ntlmssp.Type3Message;
import org.mule.service.http.netty.impl.client.auth.AuthHeaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NtlmMessageFactory
implements AuthHeaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NtlmMessageFactory.class);
    private static final int TYPE_1_MESSAGE_FLAGS = -1576500735;
    private static final byte[] MAGIC_CONSTANT = "KGS!@#$%".getBytes(StandardCharsets.US_ASCII);
    private static final CIFSContext CIFS_CONTEXT = SingletonContext.getInstance();
    private static final String NTLM_MESSAGES_PREFIX = "NTLM ";
    private static final String STARTING_NTLM_WWW_AUTHENTICATE_HEADER = "NTLM";
    private final String domain;
    private final String workstation;
    private final String username;
    private final String password;
    private Status status;

    public NtlmMessageFactory(String domain, String workstation, String username, String password) {
        this.domain = domain;
        this.workstation = workstation;
        this.username = username;
        this.password = password;
        this.status = Status.NOT_STARTED;
    }

    public byte[] createType1Message() {
        return RawType1MessageHolder.RAW_TYPE_1_MESSAGE;
    }

    public byte[] createType3Message(byte[] type2Material) throws IOException, GeneralSecurityException {
        Type2Message type2Message = new Type2Message(type2Material);
        if (type2Message.getChallenge() == null) {
            type2Message.setChallenge(new byte[0]);
        }
        Type3Message type3Message = new Type3Message(CIFS_CONTEXT, type2Message, null, NtlmMessageFactory.lmHash(this.password), this.password, this.domain, this.username, this.workstation, type2Message.getFlags(), false);
        return type3Message.toByteArray();
    }

    protected String secondChallenge(String wwwAuthenticateHeader) throws GeneralSecurityException, IOException {
        if (wwwAuthenticateHeader == null) {
            return null;
        }
        byte[] type2Material = Base64.getDecoder().decode(wwwAuthenticateHeader.substring(5));
        return this.createHeaderValue(this.createType3Message(type2Material));
    }

    private boolean mustSendType1(String wwwAuthenticateHeader) {
        return STARTING_NTLM_WWW_AUTHENTICATE_HEADER.equals(wwwAuthenticateHeader.trim());
    }

    private boolean mustSendType3(String wwwAuthenticateHeader) {
        return wwwAuthenticateHeader.startsWith(NTLM_MESSAGES_PREFIX);
    }

    private String createHeaderValue(byte[] rawNtlmMessageContent) {
        return NTLM_MESSAGES_PREFIX + Base64.getEncoder().encodeToString(rawNtlmMessageContent);
    }

    @Override
    public boolean hasFinished() {
        return Status.FINISHED == this.status;
    }

    @Override
    public String getNextHeader(String wwwAuthenticateHeader) throws Exception {
        if (wwwAuthenticateHeader == null) {
            return null;
        }
        String authHeader = null;
        if (this.status == Status.NOT_STARTED) {
            if (this.mustSendType1(wwwAuthenticateHeader)) {
                authHeader = this.createHeaderValue(this.createType1Message());
            }
            this.status = Status.WAITING_FOR_CHALLENGE;
        } else if (this.status == Status.WAITING_FOR_CHALLENGE) {
            if (this.mustSendType3(wwwAuthenticateHeader)) {
                authHeader = this.secondChallenge(wwwAuthenticateHeader);
            }
            this.status = Status.FINISHED;
        }
        return authHeader;
    }

    private static byte[] lmHash(String password) {
        try {
            byte[] oemPassword = password.toUpperCase(Locale.ROOT).getBytes(StandardCharsets.US_ASCII);
            int length = Math.min(oemPassword.length, 14);
            byte[] keyBytes = new byte[14];
            System.arraycopy(oemPassword, 0, keyBytes, 0, length);
            Key lowKey = NtlmMessageFactory.createDESKey(keyBytes, 0);
            Key highKey = NtlmMessageFactory.createDESKey(keyBytes, 7);
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, lowKey);
            byte[] lowHash = des.doFinal(MAGIC_CONSTANT);
            des.init(1, highKey);
            byte[] highHash = des.doFinal(MAGIC_CONSTANT);
            byte[] lmHash = new byte[16];
            System.arraycopy(lowHash, 0, lmHash, 0, 8);
            System.arraycopy(highHash, 0, lmHash, 8, 8);
            return lmHash;
        }
        catch (Exception e) {
            LOGGER.warn("Error found while calculating the NTLM password hash. Delegating the hashing to JCIFS default cipher", (Throwable)e);
            return null;
        }
    }

    private static Key createDESKey(byte[] bytes, int offset) {
        byte[] keyBytes = new byte[7];
        System.arraycopy(bytes, offset, keyBytes, 0, 7);
        byte[] material = new byte[]{keyBytes[0], (byte)(keyBytes[0] << 7 | (keyBytes[1] & 0xFF) >>> 1), (byte)(keyBytes[1] << 6 | (keyBytes[2] & 0xFF) >>> 2), (byte)(keyBytes[2] << 5 | (keyBytes[3] & 0xFF) >>> 3), (byte)(keyBytes[3] << 4 | (keyBytes[4] & 0xFF) >>> 4), (byte)(keyBytes[4] << 3 | (keyBytes[5] & 0xFF) >>> 5), (byte)(keyBytes[5] << 2 | (keyBytes[6] & 0xFF) >>> 6), (byte)(keyBytes[6] << 1)};
        NtlmMessageFactory.oddParity(material);
        return new SecretKeySpec(material, "DES");
    }

    private static void oddParity(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            boolean needsParity;
            byte b = bytes[i];
            boolean bl = needsParity = ((b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ b >>> 1) & 1) == 0;
            if (needsParity) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 1);
                continue;
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] & 0xFFFFFFFE);
        }
    }

    static enum Status {
        NOT_STARTED,
        WAITING_FOR_CHALLENGE,
        FINISHED;

    }

    private static final class RawType1MessageHolder {
        private static final byte[] RAW_TYPE_1_MESSAGE = RawType1MessageHolder.doCalculateType1Message();

        private RawType1MessageHolder() {
        }

        private static byte[] doCalculateType1Message() {
            Type1Message type1Message = new Type1Message(CIFS_CONTEXT, -1576500735, null, null);
            return type1Message.toByteArray();
        }
    }
}

