/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AsciiString;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.netty.impl.server.ForwardingToListenerInitializer;
import org.mule.service.http.netty.impl.server.HttpWithAPNServerHandler;
import org.mule.service.http.netty.impl.server.KeepAliveHandler;
import org.mule.service.http.netty.impl.server.MuleHttpServerExpectContinueHandler;
import org.mule.service.http.netty.impl.server.util.HttpListenerRegistry;
import org.mule.service.http.netty.impl.util.HttpLoggingHandler;

public class AcceptedConnectionChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY = "mule.http.headerSectionSize";
    private static final String MAXIMUM_INITIAL_LINE_LENGTH_PROPERTY_KEY = "mule.http.initialLineLength";
    private final SslContext sslContext;
    private final HttpListenerRegistry httpListenerRegistry;
    private final boolean usePersistentConnections;
    private final long connectionIdleTimeout;
    private final int maxInitialLineLength;
    private final int maxHeaderSize;
    private static final HttpServerUpgradeHandler.UpgradeCodecFactory upgradeCodecFactory = new HttpServerUpgradeHandler.UpgradeCodecFactory(){

        public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
            if (AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) {
                return new Http2ServerUpgradeCodec(null);
            }
            return null;
        }
    };

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, HttpServerConfiguration configuration, SslContext sslContext) {
        this(httpListenerRegistry, configuration.isUsePersistentConnections(), configuration.getConnectionIdleTimeout(), sslContext);
    }

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, boolean usePersistentConnections, int connectionIdleTimeout, SslContext sslContext) {
        this(httpListenerRegistry, usePersistentConnections, connectionIdleTimeout, sslContext, AcceptedConnectionChannelInitializer.retrieveMaxInitialLineLength(), AcceptedConnectionChannelInitializer.retrieveMaximumHeaderSectionSize());
    }

    public AcceptedConnectionChannelInitializer(HttpListenerRegistry httpListenerRegistry, boolean usePersistentConnections, int connectionIdleTimeout, SslContext sslContext, int maxInitialLineLength, int maxHeaderSize) {
        this.httpListenerRegistry = httpListenerRegistry;
        this.usePersistentConnections = usePersistentConnections;
        this.connectionIdleTimeout = connectionIdleTimeout;
        this.sslContext = sslContext;
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxHeaderSize = maxHeaderSize;
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        socketChannel.pipeline().addFirst(new ChannelHandler[]{new FlushConsolidationHandler(256, true)});
        if (this.connectionIdleTimeout != -1L) {
            socketChannel.pipeline().addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(this.connectionIdleTimeout, this.connectionIdleTimeout, this.connectionIdleTimeout, TimeUnit.MILLISECONDS));
        }
        socketChannel.pipeline().addLast("Logging Handler", (ChannelHandler)new HttpLoggingHandler());
        if (this.sslContext != null) {
            this.configureWithSslAndAPN((Channel)socketChannel);
        } else {
            this.configureHttp1(socketChannel.pipeline(), null);
        }
    }

    private void configureWithSslAndAPN(Channel channel) {
        SslHandler sslHandler = this.sslContext.newHandler(channel.alloc());
        channel.pipeline().addLast("SSL Handler", (ChannelHandler)sslHandler).addLast("Protocol Negotiation Handler", (ChannelHandler)new HttpWithAPNServerHandler(this::configureHttp1, sslHandler));
    }

    protected void configureHttp1(ChannelPipeline pipeline, SslHandler sslHandler) {
        pipeline.addLast("HTTP/1 Codec", (ChannelHandler)new HttpServerCodec(this.maxInitialLineLength, this.maxHeaderSize, 8192));
        pipeline.addLast("Expect Continue Handler", (ChannelHandler)new MuleHttpServerExpectContinueHandler());
        pipeline.addLast("Keep Alive", (ChannelHandler)new KeepAliveHandler(this.usePersistentConnections));
        pipeline.addLast("Forward Initializer", (ChannelHandler)new ForwardingToListenerInitializer(this.httpListenerRegistry, sslHandler));
    }

    private static int retrieveMaximumHeaderSectionSize() {
        try {
            return Integer.parseInt(System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY, String.valueOf(8192)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value %s for %s configuration", System.getProperty(MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY), MAXIMUM_HEADER_SECTION_SIZE_PROPERTY_KEY)), (Throwable)e);
        }
    }

    private static int retrieveMaxInitialLineLength() {
        try {
            return Integer.parseInt(System.getProperty(MAXIMUM_INITIAL_LINE_LENGTH_PROPERTY_KEY, String.valueOf(4096)));
        }
        catch (NumberFormatException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Invalid value %s for %s configuration", System.getProperty(MAXIMUM_INITIAL_LINE_LENGTH_PROPERTY_KEY), MAXIMUM_INITIAL_LINE_LENGTH_PROPERTY_KEY)), (Throwable)e);
        }
    }
}

