/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.FinishStreamingListener;
import org.mule.service.http.netty.impl.server.ResponseSender;
import org.mule.service.http.netty.impl.util.MuleToNettyUtils;

public abstract class BaseResponseSender
implements ResponseSender {
    protected final HttpRequest request;
    protected final org.mule.runtime.http.api.domain.message.response.HttpResponse response;
    private final ChannelHandlerContext ctx;
    private final ResponseStatusCallback statusCallback;
    private HttpResponse savedHeader;

    protected BaseResponseSender(HttpRequest request, ChannelHandlerContext ctx, org.mule.runtime.http.api.domain.message.response.HttpResponse response, ResponseStatusCallback statusCallback) {
        Preconditions.checkArgument((statusCallback != null ? 1 : 0) != 0, (String)"statusCallback can't be null");
        this.request = request;
        this.response = response;
        this.ctx = ctx;
        this.statusCallback = statusCallback;
        this.savedHeader = null;
    }

    @Override
    public void send() throws IOException {
        this.saveHeader(this.getNettyResponseHeader());
        this.sendContent();
    }

    private void saveHeader(HttpResponse nettyResponse) {
        this.savedHeader = nettyResponse;
    }

    protected void sendHeaderIfNeeded() {
        if (this.savedHeader != null) {
            this.ctx.write((Object)this.savedHeader);
            this.savedHeader = null;
        }
    }

    private HttpResponse getNettyResponseHeader() {
        HttpVersion httpVersion = MuleToNettyUtils.toNettyHttpVersion(this.request.getProtocol());
        DefaultHttpResponse nettyResponse = new DefaultHttpResponse(Objects.requireNonNull(httpVersion), HttpResponseStatus.valueOf((int)this.response.getStatusCode(), (String)this.response.getReasonPhrase()));
        boolean hasTransferEncoding = false;
        boolean hasContentLength = false;
        MultiMap headers = this.response.getHeaders();
        for (String key : headers.keySet()) {
            if (key.equalsIgnoreCase(HttpHeaderNames.CONTENT_LENGTH.toString())) {
                hasContentLength = true;
                nettyResponse.headers().setInt((CharSequence)key, Integer.parseInt((String)headers.get((Object)key)));
            } else {
                nettyResponse.headers().set(key, MuleToNettyUtils.sanitizeValues(headers.getAll((Object)key)));
            }
            if (!key.equalsIgnoreCase(HttpHeaderNames.TRANSFER_ENCODING.toString())) continue;
            hasTransferEncoding = true;
        }
        if (hasContentLength || hasTransferEncoding) {
            return nettyResponse;
        }
        if (this.response.getEntity().getBytesLength().isPresent() && httpVersion.equals((Object)HttpVersion.HTTP_1_1)) {
            nettyResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)this.response.getEntity().getBytesLength().getAsLong());
        }
        return nettyResponse;
    }

    protected ChannelPromise finishStreamingPromise(InputStream stream) {
        return this.createPromise(new FinishStreamingListener(stream, this.statusCallback));
    }

    protected ByteBuf createBuffer(int size) {
        return this.ctx.alloc().buffer(size, size);
    }

    protected void sendLastContentAndFinishStreaming(ByteBuf content, InputStream contentAsInputStream) {
        this.sendHeaderIfNeeded();
        this.ctx.writeAndFlush((Object)new DefaultLastHttpContent(content), this.finishStreamingPromise(contentAsInputStream));
    }

    protected ChannelPromise createPromise(ChannelFutureListener futureListener) {
        ChannelPromise channelPromise = this.ctx.newPromise();
        channelPromise.addListener((GenericFutureListener)futureListener);
        return channelPromise;
    }

    protected abstract void sendContent() throws IOException;
}

