/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.streaming;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicLong;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.server.FinishStreamingListener;
import org.mule.service.http.netty.impl.server.SendNextChunkListener;

public class StreamingEntitySender {
    public static final int ENTITY_STREAMING_BUFFER_SIZE = 8192;
    private final ChannelHandlerContext ctx;
    private final int bufferSize;
    private final Runnable beforeWrite;
    private final ResponseStatusCallback statusCallback;
    private final InputStream contentAsInputStream;
    private final OptionalLong entityLength;
    private final AtomicLong bytesAlreadySent;

    public StreamingEntitySender(HttpEntity entity, ChannelHandlerContext ctx, Runnable beforeWrite, ResponseStatusCallback statusCallback) {
        this.ctx = ctx;
        this.contentAsInputStream = entity.getContent();
        this.entityLength = entity.getBytesLength();
        this.bufferSize = this.calculateBufferSize();
        this.beforeWrite = beforeWrite;
        this.statusCallback = statusCallback;
        this.bytesAlreadySent = new AtomicLong(0L);
    }

    public void sendNextChunk() throws IOException {
        if (this.bufferSize == 0) {
            this.sendEmptyContentAndFinish(this.contentAsInputStream);
            return;
        }
        byte[] buf = new byte[this.bufferSize];
        int bytesActuallyRead = StreamingEntitySender.readChunk(this.contentAsInputStream, buf);
        if (bytesActuallyRead == -1) {
            this.sendEmptyContentAndFinish(this.contentAsInputStream);
        } else {
            ByteBuf content = this.createBuffer(bytesActuallyRead);
            content.writeBytes(buf, 0, bytesActuallyRead);
            if (this.weKnowItIsTheLastChunk(bytesActuallyRead, this.bytesAlreadySent.get())) {
                this.sendBufferWithPromise((HttpContent)new DefaultLastHttpContent(content), this.finishStreamingPromise(this.contentAsInputStream));
            } else {
                this.sendBufferWithPromise((HttpContent)new DefaultHttpContent(content), this.sendNextChunkPromise());
            }
            this.bytesAlreadySent.addAndGet(bytesActuallyRead);
        }
    }

    private boolean weKnowItIsTheLastChunk(int bytesToSend, long bytesAlreadySent) {
        if (!this.entityLength.isPresent()) {
            return false;
        }
        return bytesAlreadySent + (long)bytesToSend >= this.entityLength.getAsLong();
    }

    private int calculateBufferSize() {
        return Math.min(Math.toIntExact(this.entityLength.orElse(8192L)), 8192);
    }

    private ByteBuf createBuffer(int size) {
        return this.ctx.alloc().buffer(size, size);
    }

    private ChannelPromise createPromise(ChannelFutureListener listener) {
        ChannelPromise promise = this.ctx.newPromise();
        promise.addListener((GenericFutureListener)listener);
        return promise;
    }

    private void sendEmptyContentAndFinish(InputStream contentAsInputStream) {
        this.beforeWrite.run();
        this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, this.finishStreamingPromise(contentAsInputStream));
    }

    private ChannelPromise finishStreamingPromise(InputStream stream) {
        return this.createPromise(new FinishStreamingListener(stream, this.statusCallback));
    }

    private ChannelPromise sendNextChunkPromise() {
        ChannelPromise promise = this.ctx.newPromise();
        promise.addListener((GenericFutureListener)new SendNextChunkListener(this, this.statusCallback));
        return promise;
    }

    private void sendBufferWithPromise(HttpContent content, ChannelPromise promise) {
        this.beforeWrite.run();
        this.ctx.writeAndFlush((Object)content, promise);
    }

    private static int readChunk(InputStream contentAsInputStream, byte[] buf) throws IOException {
        try {
            return contentAsInputStream.read(buf);
        }
        catch (IllegalStateException exception) {
            if ("Buffer is closed".equals(exception.getMessage())) {
                return -1;
            }
            throw exception;
        }
    }
}

