/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.mule.weave.v2.module.writer.FlushBufferCapable;
import org.mule.weave.v2.module.writer.SStreamEncoder$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\u001dv!B\u0017/\u0011\u0003Yd!B\u001f/\u0011\u0003q\u0004\"B#\u0002\t\u00031\u0005\"B$\u0002\t\u0003Ae\u0001B\u001f/\u0001)C\u0001B\u0016\u0003\u0003\u0006\u0004%\ta\u0016\u0005\t=\u0012\u0011\t\u0011)A\u00051\"Aq\f\u0002BA\u0002\u0013\u0005\u0001\r\u0003\u0005j\t\t\u0005\r\u0011\"\u0001k\u0011!\u0001HA!A!B\u0013\t\u0007\u0002C9\u0005\u0005\u000b\u0007I\u0011\u0001:\t\u0011Y$!\u0011!Q\u0001\nMDQ!\u0012\u0003\u0005\u0002]Dqa\u001f\u0003A\u0002\u0013%A\u0010C\u0005\u0002\u0002\u0011\u0001\r\u0011\"\u0003\u0002\u0004!9\u0011q\u0001\u0003!B\u0013i\b\"CA\t\t\t\u0007I\u0011BA\n\u0011!\ti\u0002\u0002Q\u0001\n\u0005U\u0001\u0002CA\u0010\t\u0001\u0007I\u0011\u0002?\t\u0013\u0005\u0005B\u00011A\u0005\n\u0005\r\u0002bBA\u0014\t\u0001\u0006K! \u0005\n\u0003S!\u0001\u0019!C\u0005\u0003WA\u0011\"a\r\u0005\u0001\u0004%I!!\u000e\t\u0011\u0005eB\u0001)Q\u0005\u0003[A1\"a\u000f\u0005\u0001\u0004\u0005\r\u0011\"\u0003\u0002>!Y\u0011Q\t\u0003A\u0002\u0003\u0007I\u0011BA$\u0011-\tY\u0005\u0002a\u0001\u0002\u0003\u0006K!a\u0010\t\u0017\u00055C\u00011AA\u0002\u0013%\u0011q\n\u0005\f\u0003/\"\u0001\u0019!a\u0001\n\u0013\tI\u0006C\u0006\u0002^\u0011\u0001\r\u0011!Q!\n\u0005E\u0003bBA0\t\u0011%\u0011\u0011\r\u0005\b\u0003{#A\u0011AA1\u0011\u001d\tY\r\u0002C\u0001\u0003\u001bDq!a:\u0005\t\u0003\n\t\u0007C\u0004\u0002L\u0012!\t!!>\t\u000f\u0005-G\u0001\"\u0001\u0003\b!9\u00111\u001a\u0003\u0005\u0002\t5\u0001b\u0002B\u0011\t\u0011\u0005\u0013\u0011\r\u0005\u0007\u0005_!A\u0011\u0002?\t\u000f\tEB\u0001\"\u0003\u0002b!9!q\b\u0003\u0005\n\t\u0005\u0003b\u0002B,\t\u0011%!\u0011\f\u0005\b\u0005[\"A\u0011BA1\u0011\u001d\u0011Y\b\u0002C\u0005\u0003CBqA!#\u0005\t\u0013\t\t'\u0001\bT'R\u0014X-Y7F]\u000e|G-\u001a:\u000b\u0005=\u0002\u0014AB<sSR,'O\u0003\u00022e\u00051Qn\u001c3vY\u0016T!a\r\u001b\u0002\u0005Y\u0014$BA\u001b7\u0003\u00159X-\u0019<f\u0015\t9\u0004(\u0001\u0003nk2,'\"A\u001d\u0002\u0007=\u0014xm\u0001\u0001\u0011\u0005q\nQ\"\u0001\u0018\u0003\u001dM\u001bFO]3b[\u0016s7m\u001c3feN\u0011\u0011a\u0010\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Y\u0014!\u00064pe>+H\u000f];u'R\u0014X-Y7Xe&$XM\u001d\u000b\b\u0013\n]%\u0011\u0014BR!\taDaE\u0002\u0005\u0017N\u0003\"\u0001T)\u000e\u00035S!AT(\u0002\t1\fgn\u001a\u0006\u0002!\u0006!!.\u0019<b\u0013\t\u0011VJ\u0001\u0004PE*,7\r\u001e\t\u0003yQK!!\u0016\u0018\u0003%\u0019cWo\u001d5Ck\u001a4WM]\"ba\u0006\u0014G.Z\u0001\u0004_V$X#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m{\u0015AA5p\u0013\ti&L\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW.\u0001\u0003pkR\u0004\u0013aB3oG>$WM]\u000b\u0002CB\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\bG\"\f'o]3u\u0015\t1w*A\u0002oS>L!\u0001[2\u0003\u001d\rC\u0017M]:fi\u0016s7m\u001c3fe\u0006YQM\\2pI\u0016\u0014x\fJ3r)\tYg\u000e\u0005\u0002AY&\u0011Q.\u0011\u0002\u0005+:LG\u000fC\u0004p\u0011\u0005\u0005\t\u0019A1\u0002\u0007a$\u0013'\u0001\u0005f]\u000e|G-\u001a:!\u0003)\u0011WO\u001a4feNK'0Z\u000b\u0002gB\u0011\u0001\t^\u0005\u0003k\u0006\u00131!\u00138u\u0003-\u0011WO\u001a4feNK'0\u001a\u0011\u0015\t%C\u0018P\u001f\u0005\u0006-2\u0001\r\u0001\u0017\u0005\u0006?2\u0001\r!\u0019\u0005\u0006c2\u0001\ra]\u0001\u0005_B,g.F\u0001~!\t\u0001e0\u0003\u0002\u0000\u0003\n9!i\\8mK\u0006t\u0017\u0001C8qK:|F%Z9\u0015\u0007-\f)\u0001C\u0004p\u001d\u0005\u0005\t\u0019A?\u0002\u000b=\u0004XM\u001c\u0011)\u0007=\tY\u0001E\u0002A\u0003\u001bI1!a\u0004B\u0005!1x\u000e\\1uS2,\u0017A\u00012c+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005eQ\"A3\n\u0007\u0005mQM\u0001\u0006CsR,')\u001e4gKJ\f1A\u00192!\u0003AA\u0017M^3MK\u001a$xN^3s\u0007\"\f'/\u0001\u000biCZ,G*\u001a4u_Z,'o\u00115be~#S-\u001d\u000b\u0004W\u0006\u0015\u0002bB8\u0014\u0003\u0003\u0005\r!`\u0001\u0012Q\u00064X\rT3gi>4XM]\"iCJ\u0004\u0013\u0001\u00047fMR|g/\u001a:DQ\u0006\u0014XCAA\u0017!\r\u0001\u0015qF\u0005\u0004\u0003c\t%\u0001B\"iCJ\f\u0001\u0003\\3gi>4XM]\"iCJ|F%Z9\u0015\u0007-\f9\u0004\u0003\u0005p-\u0005\u0005\t\u0019AA\u0017\u00035aWM\u001a;pm\u0016\u00148\t[1sA\u0005\u0019An\u00192\u0016\u0005\u0005}\u0002\u0003BA\f\u0003\u0003J1!a\u0011f\u0005)\u0019\u0005.\u0019:Ck\u001a4WM]\u0001\bY\u000e\u0014w\fJ3r)\rY\u0017\u0011\n\u0005\t_f\t\t\u00111\u0001\u0002@\u0005!An\u00192!\u0003)\u0019\u0007.\u0019:Ck\u001a4WM]\u000b\u0003\u0003#\u0002R\u0001QA*\u0003[I1!!\u0016B\u0005\u0015\t%O]1z\u00039\u0019\u0007.\u0019:Ck\u001a4WM]0%KF$2a[A.\u0011!yG$!AA\u0002\u0005E\u0013aC2iCJ\u0014UO\u001a4fe\u0002\n!\"\u001a8tkJ,w\n]3o)\u0005Y\u0007&\u0002\u0010\u0002f\u0005E\u0004#\u0002!\u0002h\u0005-\u0014bAA5\u0003\n1A\u000f\u001b:poN\u00042!WA7\u0013\r\tyG\u0017\u0002\f\u0013>+\u0005pY3qi&|g.M\u0004\u001f\u0003g\nI)a/\u0011\t\u0005U\u00141\u0011\b\u0005\u0003o\ny\bE\u0002\u0002z\u0005k!!a\u001f\u000b\u0007\u0005u$(\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0003\u000b\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0006\u0006\u001d%AB*ue&twMC\u0002\u0002\u0002\u0006\u000b\u0014bIAF\u0003'\u000b\t,!&\u0016\t\u00055\u0015qR\u000b\u0003\u0003g\"q!!%\u0001\u0005\u0004\tYJA\u0001U\u0013\u0011\t)*a&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\tI*Q\u0001\u0007i\"\u0014xn^:\u0012\t\u0005u\u00151\u0015\t\u0004\u0001\u0006}\u0015bAAQ\u0003\n9aj\u001c;iS:<\u0007\u0003BAS\u0003Ws1\u0001QAT\u0013\r\tI+Q\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti+a,\u0003\u0013QC'o\\<bE2,'bAAU\u0003FJ1%a-\u00026\u0006]\u0016\u0011\u0014\b\u0004\u0001\u0006U\u0016bAAM\u0003F*!\u0005Q!\u0002:\n)1oY1mCF\u001aa%a\u001b\u0002\u0017\u0019dWo\u001d5Ck\u001a4WM\u001d\u0015\u0006?\u0005\u0015\u0014\u0011Y\u0019\b=\u0005M\u00141YAec%\u0019\u00131RAJ\u0003\u000b\f)*M\u0005$\u0003g\u000b),a2\u0002\u001aF*!\u0005Q!\u0002:F\u001aa%a\u001b\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000f-\fy-a5\u0002X\"9\u0011\u0011\u001b\u0011A\u0002\u0005E\u0013\u0001B2ck\u001aDa!!6!\u0001\u0004\u0019\u0018aA8gM\"1\u0011\u0011\u001c\u0011A\u0002M\f1\u0001\\3oQ\u0015\u0001\u0013QMAoc\u001dq\u00121OAp\u0003K\f\u0014bIAF\u0003'\u000b\t/!&2\u0013\r\n\u0019,!.\u0002d\u0006e\u0015'\u0002\u0012A\u0003\u0006e\u0016g\u0001\u0014\u0002l\u0005)a\r\\;tQ\"*\u0011%!\u001a\u0002lF:a$a\u001d\u0002n\u0006M\u0018'C\u0012\u0002\f\u0006M\u0015q^AKc%\u0019\u00131WA[\u0003c\fI*M\u0003#\u0001\u0006\u000bI,M\u0002'\u0003W\"2a[A|\u0011\u0019\tIP\ta\u0001g\u0006\t1\rK\u0003#\u0003K\ni0M\u0004\u001f\u0003g\nyP!\u00022\u0013\r\nY)a%\u0003\u0002\u0005U\u0015'C\u0012\u00024\u0006U&1AAMc\u0015\u0011\u0003)QA]c\r1\u00131\u000e\u000b\u0004W\n%\u0001b\u0002B\u0006G\u0001\u0007\u00111O\u0001\u0004gR\u0014HcB6\u0003\u0010\tE!1\u0003\u0005\b\u0005\u0017!\u0003\u0019AA:\u0011\u0019\t)\u000e\na\u0001g\"1\u0011\u0011\u001c\u0013A\u0002MDS\u0001JA3\u0005/\ttAHA:\u00053\u0011y\"M\u0005$\u0003\u0017\u000b\u0019Ja\u0007\u0002\u0016FJ1%a-\u00026\nu\u0011\u0011T\u0019\u0006E\u0001\u000b\u0015\u0011X\u0019\u0004M\u0005-\u0014!B2m_N,\u0007&B\u0013\u0002f\t\u0015\u0012g\u0002\u0010\u0002t\t\u001d\"QF\u0019\nG\u0005-\u00151\u0013B\u0015\u0003+\u000b\u0014bIAZ\u0003k\u0013Y#!'2\u000b\t\u0002\u0015)!/2\u0007\u0019\nY'\u0001\u0004jg>\u0003XM\\\u0001\u000boJLG/\u001a\"zi\u0016\u001c\b&B\u0014\u0002f\tU\u0012g\u0002\u0010\u0002t\t]\"QH\u0019\nG\u0005-\u00151\u0013B\u001d\u0003+\u000b\u0014bIAZ\u0003k\u0013Y$!'2\u000b\t\u0002\u0015)!/2\u0007\u0019\nY'A\tgYV\u001c\b\u000eT3gi>4XM]\"iCJ$Ra\u001bB\"\u0005\u000fBqA!\u0012)\u0001\u0004\ty$\u0001\u0002dE\"1!\u0011\n\u0015A\u0002u\f!\"\u001a8e\u001f\u001aLe\u000e];uQ\u0015A\u0013Q\rB'c\u001dq\u00121\u000fB(\u0005+\n\u0014bIAF\u0003'\u0013\t&!&2\u0013\r\n\u0019,!.\u0003T\u0005e\u0015'\u0002\u0012A\u0003\u0006e\u0016g\u0001\u0014\u0002l\u0005I\u0011.\u001c9m/JLG/\u001a\u000b\bW\nm#Q\fB0\u0011\u001d\t\t.\u000ba\u0001\u0003#Ba!!6*\u0001\u0004\u0019\bBBAmS\u0001\u00071\u000fK\u0003*\u0003K\u0012\u0019'M\u0004\u001f\u0003g\u0012)Ga\u001b2\u0013\r\nY)a%\u0003h\u0005U\u0015'C\u0012\u00024\u0006U&\u0011NAMc\u0015\u0011\u0003)QA]c\r1\u00131N\u0001\u0010S6\u0004HN\u00127vg\"\u0014UO\u001a4fe\"*!&!\u001a\u0003rE:a$a\u001d\u0003t\te\u0014'C\u0012\u0002\f\u0006M%QOAKc%\u0019\u00131WA[\u0005o\nI*M\u0003#\u0001\u0006\u000bI,M\u0002'\u0003W\n\u0011\"[7qY\u001acWo\u001d5)\u000b-\n)Ga 2\u000fy\t\u0019H!!\u0003\bFJ1%a#\u0002\u0014\n\r\u0015QS\u0019\nG\u0005M\u0016Q\u0017BC\u00033\u000bTA\t!B\u0003s\u000b4AJA6\u0003%IW\u000e\u001d7DY>\u001cX\rK\u0003-\u0003K\u0012i)M\u0004\u001f\u0003g\u0012yI!&2\u0013\r\nY)a%\u0003\u0012\u0006U\u0015'C\u0012\u00024\u0006U&1SAMc\u0015\u0011\u0003)QA]c\r1\u00131\u000e\u0005\u0006-\u000e\u0001\r\u0001\u0017\u0005\b\u00057\u001b\u0001\u0019\u0001BO\u0003\t\u00197\u000fE\u0002c\u0005?K1A!)d\u0005\u001d\u0019\u0005.\u0019:tKRDaA!*\u0004\u0001\u0004\u0019\u0018A\u00042zi\u0016\u0014UO\u001a4feNK'0\u001a")
public class SStreamEncoder
implements FlushBufferCapable {
    private final OutputStream out;
    private CharsetEncoder encoder;
    private final int bufferSize;
    private volatile boolean open;
    private final ByteBuffer bb;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    private CharBuffer lcb;
    private char[] charBuffer;

    public static SStreamEncoder forOutputStreamWriter(OutputStream outputStream, Charset charset, int n) {
        return SStreamEncoder$.MODULE$.forOutputStreamWriter(outputStream, charset, n);
    }

    public OutputStream out() {
        return this.out;
    }

    public CharsetEncoder encoder() {
        return this.encoder;
    }

    public void encoder_$eq(CharsetEncoder x$1) {
        this.encoder = x$1;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    private boolean open() {
        return this.open;
    }

    private void open_$eq(boolean x$1) {
        this.open = x$1;
    }

    private ByteBuffer bb() {
        return this.bb;
    }

    private boolean haveLeftoverChar() {
        return this.haveLeftoverChar;
    }

    private void haveLeftoverChar_$eq(boolean x$1) {
        this.haveLeftoverChar = x$1;
    }

    private char leftoverChar() {
        return this.leftoverChar;
    }

    private void leftoverChar_$eq(char x$1) {
        this.leftoverChar = x$1;
    }

    private CharBuffer lcb() {
        return this.lcb;
    }

    private void lcb_$eq(CharBuffer x$1) {
        this.lcb = x$1;
    }

    private char[] charBuffer() {
        return this.charBuffer;
    }

    private void charBuffer_$eq(char[] x$1) {
        this.charBuffer = x$1;
    }

    private void ensureOpen() throws IOException {
        if (!this.open()) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public void flushBuffer() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Stream closed");
        }
        this.implFlushBuffer();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.implWrite(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpen();
        this.implFlush();
    }

    public void write(int c) throws IOException {
        if (this.charBuffer() == null) {
            this.charBuffer_$eq(new char[this.bufferSize()]);
        }
        this.charBuffer()[0] = (char)c;
        this.write(this.charBuffer(), 0, 1);
    }

    public void write(String str) {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        char[] cbuf = null;
        if (len <= this.bufferSize()) {
            if (this.charBuffer() == null) {
                this.charBuffer_$eq(new char[this.bufferSize()]);
            }
            cbuf = this.charBuffer();
        } else {
            cbuf = new char[len];
        }
        str.getChars(off, off + len, cbuf, 0);
        this.write(cbuf, 0, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.open()) {
            return;
        }
        this.implClose();
        this.open_$eq(false);
    }

    private boolean isOpen() {
        return this.open();
    }

    private void writeBytes() throws IOException {
        int rem;
        this.bb().flip();
        int lim = this.bb().limit();
        int pos = this.bb().position();
        int n = rem = pos <= lim ? lim - pos : 0;
        if (rem > 0) {
            this.out().write(this.bb().array(), this.bb().arrayOffset() + pos, rem);
        }
        this.bb().clear();
    }

    private void flushLeftoverChar(CharBuffer cb, boolean endOfInput) throws IOException {
        Buffer buffer;
        if (!this.haveLeftoverChar() && !endOfInput) {
            return;
        }
        if (this.lcb() == null) {
            this.lcb_$eq(CharBuffer.allocate(2));
            buffer = BoxedUnit.UNIT;
        } else {
            buffer = this.lcb().clear();
        }
        Object object = this.haveLeftoverChar() ? this.lcb().put(this.leftoverChar()) : BoxedUnit.UNIT;
        Object object2 = cb != null && cb.hasRemaining() ? this.lcb().put(cb.get()) : BoxedUnit.UNIT;
        this.lcb().flip();
        boolean keepRunning = true;
        while (keepRunning && (this.lcb().hasRemaining() || endOfInput)) {
            CoderResult cr = this.encoder().encode(this.lcb(), this.bb(), endOfInput);
            if (cr.isUnderflow()) {
                if (this.lcb().hasRemaining()) {
                    this.leftoverChar_$eq(this.lcb().get());
                    if (cb != null && cb.hasRemaining()) {
                        this.flushLeftoverChar(cb, endOfInput);
                    }
                    return;
                }
                keepRunning = false;
                continue;
            }
            if (cr.isOverflow()) {
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
        this.haveLeftoverChar_$eq(false);
    }

    private void implWrite(char[] cbuf, int off, int len) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, len);
        if (this.haveLeftoverChar()) {
            this.flushLeftoverChar(cb, false);
        }
        while (cb.hasRemaining()) {
            CoderResult cr = this.encoder().encode(cb, this.bb(), false);
            if (cr.isUnderflow()) {
                if (cb.remaining() == 1) {
                    this.haveLeftoverChar_$eq(true);
                    this.leftoverChar_$eq(cb.get());
                }
                return;
            }
            if (cr.isOverflow()) {
                this.writeBytes();
                continue;
            }
            cr.throwException();
        }
    }

    private void implFlushBuffer() throws IOException {
        block0: {
            if (this.bb().position() <= 0) break block0;
            this.writeBytes();
        }
    }

    private void implFlush() throws IOException {
        block0: {
            this.implFlushBuffer();
            if (this.out() == null) break block0;
            this.out().flush();
        }
    }

    private void implClose() throws IOException {
        this.flushLeftoverChar(null, true);
        try {
            boolean keepRunning = true;
            while (keepRunning) {
                CoderResult cr = this.encoder().flush(this.bb());
                if (cr.isUnderflow()) {
                    keepRunning = false;
                    continue;
                }
                if (cr.isOverflow()) {
                    this.writeBytes();
                    continue;
                }
                cr.throwException();
            }
            if (this.bb().position() > 0) {
                this.writeBytes();
            }
            this.out().close();
        }
        catch (IOException x) {
            this.encoder().reset();
            throw x;
        }
    }

    public SStreamEncoder(OutputStream out, CharsetEncoder encoder, int bufferSize) {
        this.out = out;
        this.encoder = encoder;
        this.bufferSize = bufferSize;
        this.open = true;
        this.bb = ByteBuffer.allocate(bufferSize);
        this.haveLeftoverChar = false;
        this.leftoverChar = '\u0000';
    }
}

