/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.execution.CompletableCallback;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.connection.SourceRemoteConnectionException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.interception.SourceInterceptor;
import org.mule.runtime.api.interception.SourceInterceptorFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.notification.ConnectorMessageNotification;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.notification.PollingSourceItemNotification;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.CorrelationIdGenerator;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.construct.Pipeline;
import org.mule.runtime.core.api.context.notification.NotificationHelper;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.event.EventContextFactory;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.construct.AbstractPipeline;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.event.InternalEvent;
import org.mule.runtime.core.internal.exception.InternalExceptionUtils;
import org.mule.runtime.core.internal.execution.FlowProcessTemplate;
import org.mule.runtime.core.internal.execution.FlowProcessor;
import org.mule.runtime.core.internal.execution.MessageProcessContext;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.execution.SourceErrorException;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.core.internal.interception.InterceptorManager;
import org.mule.runtime.core.internal.message.ErrorBuilder;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyContext;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.processor.interceptor.CompletableInterceptorSourceFailureCallbackAdapter;
import org.mule.runtime.core.internal.processor.interceptor.CompletableInterceptorSourceSuccessCallbackAdapter;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.internal.util.mediatype.MediaTypeDecoratedResultCollection;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.core.internal.util.message.TransformingLegacyResultAdapterCollection;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.event.context.FlowProcessMediatorContext;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.context.SpanContextAware;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class FlowProcessMediator
implements Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowProcessMediator.class);
    @Inject
    private InterceptorManager processorInterceptorManager;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private ServerNotificationManager notificationManager;
    @Inject
    private MuleContext muleContext;
    @Inject
    private InternalProfilingService profilingService;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private final PolicyManager policyManager;
    private final PhaseResultNotifier phaseResultNotifier;
    private final List<CompletableInterceptorSourceSuccessCallbackAdapter> additionalSuccessInterceptors = new LinkedList<CompletableInterceptorSourceSuccessCallbackAdapter>();
    private final List<CompletableInterceptorSourceFailureCallbackAdapter> additionalFailureInterceptors = new LinkedList<CompletableInterceptorSourceFailureCallbackAdapter>();
    private ErrorType sourceResponseGenerateErrorType;
    private ErrorType sourceResponseSendErrorType;
    private ErrorType sourceErrorResponseGenerateErrorType;
    private ErrorType sourceErrorResponseSendErrorType;
    private ErrorType flowBackPressureErrorType;
    private NotificationHelper notificationHelper;
    private final List<SourceInterceptor> sourceInterceptors = new LinkedList<SourceInterceptor>();
    private Optional<CorrelationIdGenerator> correlationIdGenerator;
    private EventTracer<CoreEvent> coreEventTracer;

    public FlowProcessMediator(PolicyManager policyManager, PhaseResultNotifier phaseResultNotifier) {
        this.policyManager = policyManager;
        this.phaseResultNotifier = phaseResultNotifier;
    }

    public void initialise() throws InitialisationException {
        this.coreEventTracer = this.profilingService.getCoreEventTracer();
        this.notificationHelper = new NotificationHelper(this.notificationManager, ConnectorMessageNotification.class, false, this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.DISABLE_OPTIMISED_NOTIFICATION_HANDLER_DYNAMIC_RESOLUTION_UPDATE_BASED_ON_DELEGATE));
        this.sourceResponseGenerateErrorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE).orElseThrow(this.createInitialisationExceptionFor(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE));
        this.sourceResponseSendErrorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND).orElseThrow(this.createInitialisationExceptionFor(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND));
        this.sourceErrorResponseGenerateErrorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE).orElseThrow(this.createInitialisationExceptionFor(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE));
        this.sourceErrorResponseSendErrorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND).orElseThrow(this.createInitialisationExceptionFor(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND));
        this.flowBackPressureErrorType = (ErrorType)this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).orElseThrow(this.createInitialisationExceptionFor(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE));
        this.correlationIdGenerator = this.muleContext.getConfiguration().getDefaultCorrelationIdGenerator();
        if (this.processorInterceptorManager != null) {
            this.processorInterceptorManager.getSourceInterceptorFactories().stream().forEach(interceptorFactory -> {
                CompletableInterceptorSourceSuccessCallbackAdapter reactiveInterceptorSuccessAdapter = new CompletableInterceptorSourceSuccessCallbackAdapter((SourceInterceptorFactory)interceptorFactory);
                CompletableInterceptorSourceFailureCallbackAdapter reactiveInterceptorFailureAdapter = new CompletableInterceptorSourceFailureCallbackAdapter((SourceInterceptorFactory)interceptorFactory);
                try {
                    this.muleContext.getInjector().inject(reactiveInterceptorSuccessAdapter);
                    this.muleContext.getInjector().inject(reactiveInterceptorFailureAdapter);
                }
                catch (MuleException e) {
                    throw new MuleRuntimeException((Throwable)e);
                }
                this.additionalSuccessInterceptors.add(0, reactiveInterceptorSuccessAdapter);
                this.additionalFailureInterceptors.add(0, reactiveInterceptorFailureAdapter);
                this.sourceInterceptors.add(0, (SourceInterceptor)interceptorFactory.get());
            });
        }
    }

    private Supplier<InitialisationException> createInitialisationExceptionFor(ComponentIdentifier sourceResponseGenerate) {
        return () -> new InitialisationException(I18nMessageFactory.createStaticMessage((String)"ErrorType %s not found in repository", (Object[])new Object[]{sourceResponseGenerate}), (Initialisable)this);
    }

    public void process(FlowProcessTemplate template, MessageProcessContext messageProcessContext, Optional<DistributedTraceContextManager> distributedTraceContextManager) {
        try {
            MessageSource messageSource = messageProcessContext.getMessageSource();
            FlowConstruct flowConstruct = messageProcessContext.getFlowConstruct();
            CompletableFuture<Void> responseCompletion = new CompletableFuture<Void>();
            FlowProcessor flowExecutionProcessor = new FlowProcessor(publisher -> MessageProcessors.applyWithChildContext((Publisher<CoreEvent>)Flux.from((Publisher)publisher), template::routeEventAsync, Optional.empty()), flowConstruct);
            CoreEvent event = this.createEvent(template, messageSource, responseCompletion, flowConstruct);
            if (distributedTraceContextManager.isPresent()) {
                FlowProcessMediator.setEventToSourceDistributedTraceContextManager(distributedTraceContextManager, event);
            }
            template.getSourceMessage().getPollItemInformation().ifPresent(info -> this.notificationManager.fireNotification((Notification)new PollingSourceItemNotification(2304, info.getPollId(), info.getItemId(), (Serializable)info.getWatermark().orElse(null), event.getContext().getId(), info.getComponentLocation())));
            this.policyManager.addSourcePointcutParametersIntoEvent(messageSource, event.getMessage().getAttributes(), (InternalEvent)event);
            try {
                SourcePolicy policy = this.policyManager.createSourcePolicyInstance(messageSource, event, flowExecutionProcessor, template);
                DefaultFlowProcessMediatorContext phaseContext = new DefaultFlowProcessMediatorContext(template, this.getTerminateConsumer(messageSource, template), responseCompletion);
                ((InternalEvent)event).setFlowProcessMediatorContext(phaseContext);
                BaseEventContext rootContext = ((BaseEventContext)event.getContext()).getRootContext();
                this.sourceInterceptors.forEach(sourceInterceptor -> rootContext.onTerminated((e, t) -> sourceInterceptor.afterTerminated(messageSource.getLocation(), (EventContext)rootContext)));
                flowConstruct.getStatistics().incMessagesDispatched();
                this.dispatch(event, policy, (Pipeline)flowConstruct, phaseContext);
            }
            catch (Exception e) {
                template.sendFailureResponseToClient(messageProcessContext.getMessagingExceptionResolver().resolve(new MessagingException(event, e), this.errorTypeLocator, this.exceptionContextProviders), template.getFailedExecutionResponseParametersFunction().apply(event), (CompletableCallback<Void>)CompletableCallback.always(() -> this.phaseResultNotifier.phaseFailure(e)));
                ((BaseEventContext)event.getContext()).error(e);
                responseCompletion.complete(null);
            }
        }
        catch (Exception e) {
            this.phaseResultNotifier.phaseFailure(e);
        }
    }

    private static void setEventToSourceDistributedTraceContextManager(Optional<DistributedTraceContextManager> sourceDistributedTraceContextManager, CoreEvent event) {
        DistributedTraceContextManager sourceTraceContextManager = sourceDistributedTraceContextManager.get();
        if (sourceTraceContextManager instanceof SpanContextAware) {
            ((SpanContextAware)sourceTraceContextManager).setSpanContext(((SpanContextAware)event.getContext()).getSpanContext());
        }
    }

    private void dispatch(final CoreEvent event, SourcePolicy sourcePolicy, final Pipeline flowConstruct, final DefaultFlowProcessMediatorContext ctx) throws Exception {
        try {
            this.onMessageReceived(event, flowConstruct, ctx);
            flowConstruct.checkBackpressure(event);
            ctx.template.getNotificationFunctions().forEach(notificationFunction -> this.notificationManager.fireNotification((Notification)notificationFunction.apply(event, flowConstruct.getSource())));
            sourcePolicy.process(event, ctx.template, new CompletableCallback<Either<SourcePolicyFailureResult, SourcePolicySuccessResult>>(){

                public void complete(Either<SourcePolicyFailureResult, SourcePolicySuccessResult> value) {
                    FlowProcessMediator.this.dispatchResponse(flowConstruct, ctx, (Either<SourcePolicyFailureResult, SourcePolicySuccessResult>)value, event);
                }

                public void error(Throwable e) {
                    FlowProcessMediator.this.dispatchResponse(flowConstruct, ctx, (Either<SourcePolicyFailureResult, SourcePolicySuccessResult>)Either.left((Object)new SourcePolicyFailureResult(new MessagingException(event, e), Collections::emptyMap)), event);
                }
            });
        }
        catch (Exception e) {
            e = (Exception)Exceptions.unwrap(e);
            this.coreEventTracer.endCurrentSpan((Event)event);
            if (e instanceof FlowBackPressureException) {
                ((BaseEventContext)event.getContext()).error(e);
                this.dispatchResponse(flowConstruct, ctx, this.mapBackPressureExceptionToPolicyFailureResult(ctx.template, event, (FlowBackPressureException)((Object)e)), event);
            }
            throw e;
        }
    }

    private void dispatchResponse(Pipeline flowConstruct, DefaultFlowProcessMediatorContext ctx, Either<SourcePolicyFailureResult, SourcePolicySuccessResult> result, CoreEvent event) {
        result.apply(this.policyFailure(flowConstruct, ctx, event), this.policySuccess(flowConstruct, ctx, event));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(Pipeline flowConstruct, DefaultFlowProcessMediatorContext ctx, Throwable exception) {
        try {
            if (exception != null) {
                this.onFailure(flowConstruct, ctx).accept(exception);
            } else {
                this.phaseResultNotifier.phaseSuccessfully();
            }
        }
        finally {
            ctx.responseCompletion.complete(null);
        }
    }

    protected Either<SourcePolicyFailureResult, SourcePolicySuccessResult> mapBackPressureExceptionToPolicyFailureResult(FlowProcessTemplate template, CoreEvent event, FlowBackPressureException exception) {
        CoreEvent errorEvent = CoreEvent.builder(event).error(ErrorBuilder.builder((Throwable)((Object)exception)).errorType(this.flowBackPressureErrorType).build()).build();
        SourcePolicyFailureResult result = new SourcePolicyFailureResult(new MessagingException(errorEvent, (Throwable)((Object)exception), exception.getFlow()), () -> template.getFailedExecutionResponseParametersFunction().apply(errorEvent));
        return Either.left((Object)result);
    }

    private Consumer<SourcePolicySuccessResult> policySuccess(final Pipeline flowConstruct, final DefaultFlowProcessMediatorContext ctx, final CoreEvent event) {
        return successResult -> {
            this.fireNotification(flowConstruct.getSource(), successResult.getResult(), flowConstruct, 805);
            CompletableCallback<Void> responseCallback = new CompletableCallback<Void>(){

                public void complete(Void value) {
                    FlowProcessMediator.this.onTerminate(flowConstruct, ctx, (Either<Throwable, CoreEvent>)Either.right((Object)successResult.getResult()));
                    FlowProcessMediator.this.finish(flowConstruct, ctx, null);
                    FlowProcessMediator.this.coreEventTracer.endCurrentSpan((Event)event);
                }

                public void error(Throwable e) {
                    FlowProcessMediator.this.policySuccessError(flowConstruct, new SourceErrorException(successResult.getResult(), FlowProcessMediator.this.sourceResponseSendErrorType, e));
                }
            };
            try {
                if (this.additionalSuccessInterceptors.isEmpty()) {
                    ctx.template.sendResponseToClient(successResult.getResult(), successResult.getResponseParameters().get(), responseCallback);
                } else {
                    BiConsumer<SourcePolicySuccessResult, CompletableCallback> sendResponseToClient = (result, callback) -> ctx.template.sendResponseToClient(result.getResult(), result.getResponseParameters().get(), (CompletableCallback<Void>)callback);
                    for (CompletableInterceptorSourceSuccessCallbackAdapter interceptor : this.additionalSuccessInterceptors) {
                        sendResponseToClient = interceptor.apply(flowConstruct.getSource(), sendResponseToClient);
                    }
                    sendResponseToClient.accept((SourcePolicySuccessResult)successResult, (CompletableCallback)responseCallback);
                }
            }
            catch (Exception e) {
                this.policySuccessError(flowConstruct, new SourceErrorException(successResult.getResult(), this.sourceResponseGenerateErrorType, e));
            }
        };
    }

    private Consumer<SourcePolicyFailureResult> policyFailure(final Pipeline flowConstruct, final DefaultFlowProcessMediatorContext ctx, CoreEvent coreEvent) {
        return failureResult -> {
            this.fireNotification(flowConstruct.getSource(), failureResult.getMessagingException().getEvent(), flowConstruct, 806);
            CompletableCallback<Void> responseCallback = new CompletableCallback<Void>(){

                public void complete(Void value) {
                    FlowProcessMediator.this.onTerminate(flowConstruct, ctx, (Either<Throwable, CoreEvent>)Either.left((Object)((Object)failureResult.getMessagingException())));
                    FlowProcessMediator.this.finish(flowConstruct, ctx, null);
                }

                public void error(Throwable e) {
                    FlowProcessMediator.this.finish(flowConstruct, ctx, e);
                }
            };
            try {
                if (this.additionalFailureInterceptors.isEmpty()) {
                    this.sendErrorResponse(failureResult.getMessagingException(), event -> failureResult.getErrorResponseParameters().get(), ctx, responseCallback);
                } else {
                    BiConsumer<SourcePolicyFailureResult, CompletableCallback> sendErrorResponse = (result, callback) -> this.sendErrorResponse(result.getMessagingException(), event -> result.getErrorResponseParameters().get(), ctx, (CompletableCallback<Void>)callback);
                    for (CompletableInterceptorSourceFailureCallbackAdapter interceptor : this.additionalFailureInterceptors) {
                        sendErrorResponse = interceptor.apply(flowConstruct.getSource(), sendErrorResponse);
                    }
                    sendErrorResponse.accept((SourcePolicyFailureResult)failureResult, (CompletableCallback)responseCallback);
                }
            }
            catch (Exception e) {
                responseCallback.error((Throwable)((Object)new SourceErrorException(failureResult.getResult(), this.sourceErrorResponseGenerateErrorType, e, failureResult.getMessagingException())));
            }
            finally {
                this.coreEventTracer.endCurrentSpan((Event)coreEvent);
            }
        };
    }

    private void policySuccessError(Pipeline flowConstruct, SourceErrorException see) {
        MessagingException messagingException = see.toMessagingException(this.exceptionContextProviders, flowConstruct.getSource());
        if (flowConstruct instanceof AbstractPipeline) {
            ((AbstractPipeline)flowConstruct).errorRouterForSourceResponseError(flow -> me -> {
                final InternalEvent event = (InternalEvent)((MessagingException)((Object)((Object)((Object)me)))).getEvent();
                final DefaultFlowProcessMediatorContext ctx = (DefaultFlowProcessMediatorContext)event.getFlowProcessMediatorContext();
                this.sendErrorResponse((MessagingException)((Object)((Object)((Object)me))), SourcePolicyContext.from(event).getResponseParametersProcessor().getFailedExecutionResponseParametersFunction(), ctx, new CompletableCallback<Void>(){

                    public void complete(Void value) {
                        FlowProcessMediator.this.onTerminate(flow, ctx, (Either<Throwable, CoreEvent>)Either.left((Object)me));
                        FlowProcessMediator.this.finish(flow, ctx, null);
                        FlowProcessMediator.this.coreEventTracer.endCurrentSpan((Event)event);
                    }

                    public void error(Throwable e) {
                        FlowProcessMediator.this.finish(flow, ctx, e);
                        FlowProcessMediator.this.coreEventTracer.endCurrentSpan((Event)event);
                    }
                });
            }).accept((Exception)((Object)messagingException));
        }
    }

    private void sendErrorResponse(MessagingException messagingException, Function<CoreEvent, Map<String, Object>> errorParameters, DefaultFlowProcessMediatorContext ctx, final CompletableCallback<Void> callback) {
        final CoreEvent event = messagingException.getEvent();
        try {
            if (!ExceptionUtils.containsType((Throwable)((Object)messagingException), SourceRemoteConnectionException.class)) {
                ctx.template.sendFailureResponseToClient(messagingException, errorParameters.apply(event), new CompletableCallback<Void>(){

                    public void complete(Void value) {
                        callback.complete((Object)value);
                    }

                    public void error(Throwable e) {
                        callback.error((Throwable)((Object)new SourceErrorException(CoreEvent.builder(event).error(ErrorBuilder.builder(e).errorType(FlowProcessMediator.this.sourceErrorResponseSendErrorType).build()).build(), FlowProcessMediator.this.sourceErrorResponseSendErrorType, e)));
                    }
                });
            } else {
                callback.complete(null);
            }
        }
        catch (Exception e) {
            callback.error((Throwable)((Object)new SourceErrorException(event, this.sourceErrorResponseGenerateErrorType, e, messagingException)));
        }
    }

    private Consumer<Throwable> onFailure(Pipeline flowConstruct, DefaultFlowProcessMediatorContext ctx) {
        return throwable -> {
            this.onTerminate(flowConstruct, ctx, (Either<Throwable, CoreEvent>)Either.left((Object)throwable));
            throwable = throwable instanceof SourceErrorException ? throwable.getCause() : throwable;
            Exception failureException = throwable instanceof Exception ? (Exception)throwable : new DefaultMuleException(throwable);
            this.phaseResultNotifier.phaseFailure(failureException);
        };
    }

    private Consumer<Either<MessagingException, CoreEvent>> getTerminateConsumer(MessageSource messageSource, FlowProcessTemplate template) {
        return eventOrException -> template.afterPhaseExecution((Either<MessagingException, CoreEvent>)eventOrException.mapLeft(messagingException -> {
            messagingException.setProcessedEvent(InternalExceptionUtils.createErrorEvent(messagingException.getEvent(), messageSource, messagingException, this.errorTypeLocator));
            return messagingException;
        }));
    }

    private void onMessageReceived(CoreEvent event, Pipeline flowConstruct, DefaultFlowProcessMediatorContext ctx) {
        this.fireNotification(flowConstruct.getSource(), event, flowConstruct, 801);
        ctx.template.getNotificationFunctions().forEach(notificationFunction -> this.notificationManager.fireNotification((Notification)notificationFunction.apply(event, flowConstruct.getSource())));
    }

    private String evaluateCorrelationIdExpressionGenerator() {
        if (this.correlationIdGenerator.isPresent()) {
            return this.correlationIdGenerator.get().generateCorrelationId();
        }
        return null;
    }

    private String resolveSourceCorrelationId(SourceResultAdapter adapter) {
        return adapter.getCorrelationId().orElseGet(() -> this.evaluateCorrelationIdExpressionGenerator());
    }

    private CoreEvent createEvent(FlowProcessTemplate template, MessageSource source, CompletableFuture<Void> responseCompletion, FlowConstruct flowConstruct) {
        SourceResultAdapter adapter = template.getSourceMessage();
        InternalEvent.Builder eventBuilder = this.createEventBuilder(source.getLocation(), responseCompletion, flowConstruct, this.resolveSourceCorrelationId(adapter), adapter.getDistributedTraceContextManager());
        InternalEvent coreEvent = eventBuilder.message(eventCtx -> {
            Message eventMessage;
            Result result = adapter.getResult();
            Object resultValue = result.getOutput();
            if (resultValue instanceof Collection && adapter.isCollection()) {
                TransformingLegacyResultAdapterCollection resultCollection = new TransformingLegacyResultAdapterCollection((Collection)resultValue);
                eventMessage = MessageUtils.toMessage(Result.builder().output(MessageUtils.messageCollection(new MediaTypeDecoratedResultCollection(resultCollection, adapter.getPayloadMediaTypeResolver()), adapter.getCursorProviderFactory(), ((BaseEventContext)eventCtx).getRootContext(), source.getLocation())).mediaType(result.getMediaType().orElse(MediaType.ANY)).build());
            } else {
                eventMessage = MessageUtils.toMessage(result, adapter.getMediaType(), adapter.getCursorProviderFactory(), ((BaseEventContext)eventCtx).getRootContext(), source.getLocation());
            }
            return eventMessage;
        }).build();
        if (adapter.getRootSpanName() != null) {
            this.coreEventTracer.setCurrentSpanName((Event)coreEvent, adapter.getRootSpanName());
        }
        this.coreEventTracer.addCurrentSpanAttributes((Event)coreEvent, adapter.getSpanRootAttributes());
        return coreEvent;
    }

    private InternalEvent.Builder createEventBuilder(ComponentLocation sourceLocation, CompletableFuture<Void> responseCompletion, FlowConstruct flowConstruct, String correlationId, DistributedTraceContextManager distributedTraceContextManager) {
        return InternalEvent.builder(this.getEventContext(sourceLocation, responseCompletion, flowConstruct, correlationId, distributedTraceContextManager));
    }

    private EventContext getEventContext(ComponentLocation sourceLocation, CompletableFuture<Void> responseCompletion, FlowConstruct flowConstruct, String correlationId, final DistributedTraceContextManager distributedTraceContextManager) {
        EventContext eventContext = EventContextFactory.create(flowConstruct, sourceLocation, correlationId, Optional.of(responseCompletion));
        this.coreEventTracer.injectDistributedTraceContext(eventContext, new DistributedTraceContextGetter(){

            public Iterable<String> keys() {
                return distributedTraceContextManager.getRemoteTraceContextMap().keySet();
            }

            public Optional<String> get(String key) {
                return Optional.ofNullable((String)distributedTraceContextManager.getRemoteTraceContextMap().get(key));
            }
        });
        return eventContext;
    }

    private void onTerminate(Pipeline flowConstruct, DefaultFlowProcessMediatorContext ctx, Either<Throwable, CoreEvent> result) {
        FunctionalUtils.safely(result.mapLeft(throwable -> {
            if (throwable instanceof MessagingException) {
                return (MessagingException)((Object)((Object)throwable));
            }
            if (throwable instanceof SourceErrorException) {
                return ((SourceErrorException)((Object)((Object)throwable))).toMessagingException(this.exceptionContextProviders, flowConstruct.getSource());
            }
            return null;
        }), mapped -> ctx.terminateConsumer.accept(mapped), e -> {});
    }

    private void fireNotification(Component source, CoreEvent event, FlowConstruct flow, int action) {
        block3: {
            try {
                if (event == null && (event = PrivilegedEvent.getCurrentEvent()) == null) {
                    return;
                }
                this.notificationHelper.fireNotification(source, event, flow.getLocation(), action);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) break block3;
                LOGGER.warn(String.format("Could not fire notification. Action: %s", action), (Throwable)e);
            }
        }
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public static final class DefaultFlowProcessMediatorContext
    implements FlowProcessMediatorContext {
        private final FlowProcessTemplate template;
        private final Consumer<Either<MessagingException, CoreEvent>> terminateConsumer;
        private final CompletableFuture<Void> responseCompletion;

        private DefaultFlowProcessMediatorContext(FlowProcessTemplate template, Consumer<Either<MessagingException, CoreEvent>> terminateConsumer, CompletableFuture<Void> responseCompletion) {
            this.template = template;
            this.terminateConsumer = terminateConsumer;
            this.responseCompletion = responseCompletion;
        }

        @Override
        public DefaultFlowProcessMediatorContext copy() {
            return this;
        }
    }
}

