/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.HostLanguage;

public class PipelineConfiguration {
    private Configuration config;
    private Controller controller;
    private ParseOptions parseOptions;
    private HostLanguage hostLanguage = HostLanguage.UNKNOWN;
    private Map<String, Object> components;
    private XPathContext context;
    private Function<NodeInfo, Object> copyInformee;

    public PipelineConfiguration(Configuration config) {
        this.config = config;
        this.parseOptions = new ParseOptions();
    }

    public PipelineConfiguration(Configuration config, ParseOptions parseOptions) {
        this.config = config;
        this.parseOptions = parseOptions;
    }

    public PipelineConfiguration(PipelineConfiguration p) {
        this.config = p.config;
        this.controller = p.controller;
        this.parseOptions = p.parseOptions;
        this.hostLanguage = p.hostLanguage;
        if (p.components != null) {
            this.components = new HashMap<String, Object>(p.components);
        }
        this.context = p.context;
        this.copyInformee = null;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public ErrorReporter getErrorReporter() {
        ErrorReporter reporter = this.getParseOptions().getErrorReporter();
        if (reporter == null) {
            reporter = this.controller == null ? this.config.makeErrorReporter() : this.controller.getErrorReporter();
        }
        return reporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.parseOptions = this.getParseOptions().withErrorReporter(errorReporter);
    }

    public void setParseOptions(ParseOptions options) {
        this.parseOptions = options;
    }

    public ParseOptions getParseOptions() {
        if (this.parseOptions == null) {
            this.parseOptions = this.config.getParseOptions();
        }
        return this.parseOptions;
    }

    public void setUseXsiSchemaLocation(boolean recognize) {
        this.parseOptions = this.getParseOptions().withUseXsiSchemaLocation(recognize);
    }

    public void setRecoverFromValidationErrors(boolean recover) {
        this.parseOptions = this.getParseOptions().withContinueAfterValidationErrors(recover);
    }

    public boolean isRecoverFromValidationErrors() {
        return this.getParseOptions().isContinueAfterValidationErrors();
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public HostLanguage getHostLanguage() {
        if (this.hostLanguage == HostLanguage.UNKNOWN) {
            this.hostLanguage = this.controller == null ? HostLanguage.UNKNOWN : this.controller.getExecutable().getHostLanguage();
        }
        return this.hostLanguage;
    }

    public boolean isXSLT() {
        return this.getHostLanguage() == HostLanguage.XSLT;
    }

    public void setHostLanguage(HostLanguage language) {
        this.hostLanguage = language;
    }

    public void setComponent(String name, Object value) {
        if (this.components == null) {
            this.components = new HashMap<String, Object>();
        }
        this.components.put(name, value);
    }

    public void setCopyInformee(Function<NodeInfo, Object> informee) {
        this.copyInformee = informee;
    }

    public Function<NodeInfo, Object> getCopyInformee() {
        return this.copyInformee;
    }

    public Object getComponent(String name) {
        if (this.components == null) {
            return null;
        }
        return this.components.get(name);
    }

    public void setXPathContext(XPathContext context) {
        this.context = context;
    }

    public XPathContext getXPathContext() {
        return this.context;
    }
}

