/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.retry.ReconnectionConfig;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.BaseOAuthConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.CustomOAuthParameters;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthUtils;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthObjectStoreConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConfig;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.OAuthCallbackConfig;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;

public class AuthorizationCodeConnectionProviderObjectBuilder<C>
extends BaseOAuthConnectionProviderObjectBuilder<C>
implements Startable {
    private final AuthorizationCodeOAuthHandler authCodeHandler;
    private final AuthorizationCodeGrantType grantType;
    private final Map<Field, String> callbackValues;
    Supplier<Boolean> forceInvalidateStatusRetrievalSupplier;

    public AuthorizationCodeConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, ReconnectionConfig reconnectionConfig, AuthorizationCodeGrantType grantType, AuthorizationCodeOAuthHandler authCodeHandler, ExtensionModel extensionModel, ExpressionManager expressionManager, MuleContext muleContext) {
        super(providerModel, resolverSet, poolingProfile, reconnectionConfig, extensionModel, expressionManager, muleContext);
        this.authCodeHandler = authCodeHandler;
        this.grantType = grantType;
        this.callbackValues = ExtensionsOAuthUtils.getCallbackValuesExtractors(providerModel);
        this.forceInvalidateStatusRetrievalSupplier = () -> !muleContext.getClusterId().isEmpty();
    }

    public void start() throws MuleException {
        this.authCodeHandler.register(this.getInitialOAuthConfig());
    }

    @Override
    protected ConnectionProvider<C> doBuild(ResolverSetResult result) throws MuleException {
        Object provider = super.doBuild(result);
        Map<String, String> authCodeParams = this.getAuthCodeParameterMap(result);
        CustomOAuthParameters customParameters = this.getCustomParameters(result);
        AuthorizationCodeConfig config = new AuthorizationCodeConfig(this.ownerConfigName, this.buildOAuthObjectStoreConfig(result), customParameters, this.callbackValues, this.grantType, this.buildOAuthCallbackConfig(result), authCodeParams.get("consumerKey"), authCodeParams.get("consumerSecret"), authCodeParams.get("authorizationUrl"), authCodeParams.get("accessTokenUrl"), authCodeParams.get("scopes"), authCodeParams.get("resourceOwnerId"), authCodeParams.get("before"), authCodeParams.get("after"));
        provider = new AuthorizationCodeConnectionProviderWrapper(provider, config, this.callbackValues, this.authCodeHandler, this.reconnectionConfig, this.forceInvalidateStatusRetrievalSupplier);
        return provider;
    }

    @Override
    public Pair<ConnectionProvider<C>, ResolverSetResult> build(ValueResolvingContext context) throws MuleException {
        ResolverSetResult result = this.resolverSet.resolve(context);
        Object provider = super.doBuild(result);
        Map<String, String> authCodeParams = this.getAuthCodeParameterMap(context.getEvent());
        CustomOAuthParameters customParameters = this.getCustomParameters(result);
        AuthorizationCodeConfig config = new AuthorizationCodeConfig(this.ownerConfigName, this.buildOAuthObjectStoreConfig(context.getEvent()), customParameters, this.callbackValues, this.grantType, this.buildOAuthCallbackConfig(context.getEvent()), authCodeParams.get("consumerKey"), authCodeParams.get("consumerSecret"), authCodeParams.get("authorizationUrl"), authCodeParams.get("accessTokenUrl"), authCodeParams.get("scopes"), authCodeParams.get("resourceOwnerId"), authCodeParams.get("before"), authCodeParams.get("after"));
        provider = new AuthorizationCodeConnectionProviderWrapper(provider, config, this.callbackValues, this.authCodeHandler, this.reconnectionConfig, this.forceInvalidateStatusRetrievalSupplier);
        return new Pair(provider, (Object)result);
    }

    private Map<String, String> getAuthCodeParameterMap(ResolverSetResult result) {
        return (Map)result.get("oauthAuthorizationCode");
    }

    private Map<String, String> getAuthCodeParameterMap(CoreEvent event) throws MuleException {
        ValueResolver<?> valueResolver = this.resolverSet.getResolvers().get("oauthAuthorizationCode");
        try (ValueResolvingContext context = this.getResolvingContextFor(event);){
            Map map = (Map)valueResolver.resolve(context);
            return map;
        }
    }

    private OAuthCallbackConfig buildOAuthCallbackConfig(CoreEvent event) throws MuleException {
        ValueResolver<?> valueResolver = this.resolverSet.getResolvers().get("oauthCallbackConfig");
        try (ValueResolvingContext context = this.getResolvingContextFor(event);){
            Map map = (Map)valueResolver.resolve(context);
            OAuthCallbackConfig oAuthCallbackConfig = this.buildOAuthCallbackConfig(map);
            return oAuthCallbackConfig;
        }
    }

    private OAuthCallbackConfig buildOAuthCallbackConfig(ResolverSetResult result) {
        Map map = (Map)result.get("oauthCallbackConfig");
        return this.buildOAuthCallbackConfig(map);
    }

    private OAuthCallbackConfig buildOAuthCallbackConfig(Map<String, Object> map) {
        return new OAuthCallbackConfig((String)map.get("listenerConfig"), this.sanitizePath((String)map.get("callbackPath")), this.sanitizePath((String)map.get("authorizePath")), (String)map.get("externalCallbackUrl"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationCodeConfig getInitialOAuthConfig() throws MuleException {
        CoreEvent initialiserEvent = null;
        ValueResolvingContext ctxForConfig = null;
        ValueResolvingContext ctxForCallback = null;
        try {
            initialiserEvent = NullEventFactory.getNullEvent((MuleContext)this.muleContext);
            ValueResolver<?> oauthAuthCodeGroup = this.resolverSet.getResolvers().get("oauthAuthorizationCode");
            MapValueResolver mapResolver = this.staticOnly((MapValueResolver)oauthAuthCodeGroup);
            Object authCodeParams = mapResolver.resolve(ctxForConfig);
            ctxForConfig = this.getResolvingContextFor(initialiserEvent);
            Optional<OAuthObjectStoreConfig> storeConfig = this.buildOAuthObjectStoreConfig(initialiserEvent);
            mapResolver = this.staticOnly((MapValueResolver)this.resolverSet.getResolvers().get("oauthCallbackConfig"));
            ctxForCallback = this.getResolvingContextFor(initialiserEvent);
            OAuthCallbackConfig callbackConfig = this.buildOAuthCallbackConfig((Map<String, Object>)mapResolver.resolve(ctxForCallback));
            CustomOAuthParameters customParameters = this.getCustomParameters(initialiserEvent);
            AuthorizationCodeConfig authorizationCodeConfig = new AuthorizationCodeConfig(this.ownerConfigName, storeConfig, customParameters, this.callbackValues, this.grantType, callbackConfig, (String)authCodeParams.get("consumerKey"), (String)authCodeParams.get("consumerSecret"), (String)authCodeParams.get("authorizationUrl"), (String)authCodeParams.get("accessTokenUrl"), (String)authCodeParams.get("scopes"), (String)authCodeParams.get("resourceOwnerId"), (String)authCodeParams.get("before"), (String)authCodeParams.get("after"));
            return authorizationCodeConfig;
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
            if (ctxForCallback != null) {
                ctxForCallback.close();
            }
            if (ctxForConfig != null) {
                ctxForConfig.close();
            }
        }
    }
}

