/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.soap;

import java.net.URL;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.extension.api.soap.WebServiceDefinitionBuilder;

public final class WebServiceDefinition {
    private final String serviceId;
    private final String friendlyName;
    private final URL wsdlUrl;
    private final URL address;
    private final String service;
    private final String port;
    private final List<String> excludedOperationNames;

    WebServiceDefinition(String serviceId, String friendlyName, URL wsdlUrl, URL address, String service, String port, List<String> excludedOperations) {
        this.serviceId = serviceId;
        this.friendlyName = friendlyName;
        this.wsdlUrl = wsdlUrl;
        this.address = address;
        this.service = service;
        this.port = port;
        this.excludedOperationNames = excludedOperations;
    }

    public static WebServiceDefinitionBuilder builder() {
        return new WebServiceDefinitionBuilder();
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public String getService() {
        return this.service;
    }

    public String getPort() {
        return this.port;
    }

    public List<String> getExcludedOperations() {
        return this.excludedOperationNames;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public URL getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebServiceDefinition that = (WebServiceDefinition)o;
        return Objects.equals(this.serviceId, that.serviceId) && Objects.equals(this.friendlyName, that.friendlyName) && Objects.equals(this.wsdlUrl, that.wsdlUrl) && Objects.equals(this.address, that.address) && Objects.equals(this.service, that.service) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.serviceId, this.friendlyName, this.wsdlUrl, this.address, this.service, this.port);
    }
}

