/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.wsdl.xml.WSDLLocator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.cxf.wsdl11.CatalogWSDLLocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.wsdl.parser.locator.ResourceLocator;
import org.xml.sax.InputSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/mule/wsdl/parser/WsdlLocator;", "Ljavax/wsdl/xml/WSDLLocator;", "wsdlLocation", "", "resourceLocator", "Lorg/mule/wsdl/parser/locator/ResourceLocator;", "(Ljava/lang/String;Lorg/mule/wsdl/parser/locator/ResourceLocator;)V", "delegateLocator", "latestImportUri", "streams", "Ljava/util/ArrayList;", "Ljava/io/InputStream;", "close", "", "getBaseInputSource", "Lorg/xml/sax/InputSource;", "getBaseURI", "getImportInputSource", "parentLocation", "importLocation", "getInputSource", "url", "getLatestImportURI", "mule-wsdl-parser"})
@SourceDebugExtension(value={"SMAP\nWsdlLocator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WsdlLocator.kt\norg/mule/wsdl/parser/WsdlLocator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1855#2,2:109\n*S KotlinDebug\n*F\n+ 1 WsdlLocator.kt\norg/mule/wsdl/parser/WsdlLocator\n*L\n88#1:109,2\n*E\n"})
public final class WsdlLocator
implements WSDLLocator {
    @NotNull
    private final String wsdlLocation;
    @NotNull
    private final ResourceLocator resourceLocator;
    @NotNull
    private final WSDLLocator delegateLocator;
    @NotNull
    private final ArrayList<InputStream> streams;
    @NotNull
    private String latestImportUri;

    public WsdlLocator(@NotNull String wsdlLocation, @NotNull ResourceLocator resourceLocator) {
        Intrinsics.checkNotNullParameter((Object)wsdlLocation, (String)"wsdlLocation");
        Intrinsics.checkNotNullParameter((Object)resourceLocator, (String)"resourceLocator");
        this.wsdlLocation = wsdlLocation;
        this.resourceLocator = resourceLocator;
        this.streams = new ArrayList();
        this.latestImportUri = this.wsdlLocation;
        this.delegateLocator = (WSDLLocator)new CatalogWSDLLocator(this.wsdlLocation);
    }

    @Nullable
    public InputSource getBaseInputSource() {
        return this.resourceLocator.handles(this.wsdlLocation) ? this.getInputSource(this.wsdlLocation) : this.delegateLocator.getBaseInputSource();
    }

    @NotNull
    public InputSource getImportInputSource(@NotNull String parentLocation, @NotNull String importLocation) {
        Intrinsics.checkNotNullParameter((Object)parentLocation, (String)"parentLocation");
        Intrinsics.checkNotNullParameter((Object)importLocation, (String)"importLocation");
        try {
            if (this.resourceLocator.handles(importLocation)) {
                this.latestImportUri = importLocation;
                return this.getInputSource(this.latestImportUri);
            }
            InputSource importInputSource = this.delegateLocator.getImportInputSource(parentLocation, importLocation);
            String string = this.delegateLocator.getLatestImportURI();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"delegateLocator.latestImportURI");
            this.latestImportUri = string;
            Intrinsics.checkNotNullExpressionValue((Object)importInputSource, (String)"importInputSource");
            return importInputSource;
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder().append("Error retrieving the following WSDL resource: ");
            String string = this.latestImportUri;
            Intrinsics.checkNotNull((Object)string);
            throw new RuntimeException(stringBuilder.append(string).toString(), e);
        }
    }

    @NotNull
    public String getBaseURI() {
        return this.wsdlLocation;
    }

    @NotNull
    public String getLatestImportURI() {
        return this.latestImportUri;
    }

    public void close() {
        Iterable $this$forEach$iv = this.streams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InputStream stream = (InputStream)element$iv;
            boolean bl = false;
            try {
                stream.close();
            }
            catch (IOException iOException) {
            }
        }
    }

    private final InputSource getInputSource(String url) {
        try {
            InputStream resultStream = this.resourceLocator.getResource(url);
            this.streams.add(resultStream);
            return new InputSource(resultStream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error fetching the resource [" + url + "]: " + e.getMessage(), e);
        }
    }
}

