/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.entry;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.ResolverFeature;
import org.xmlresolver.logging.ResolverLogger;

public abstract class Entry {
    protected final ResolverLogger logger;
    protected final ResolverConfiguration config;
    public static final Pattern NCNAME_RE = Pattern.compile("^[A-Za-z0-9_]+$");
    public static String rarr = " \u2192 ";
    public final URI baseURI;
    public final String id;
    public final HashMap<String, String> extra = new HashMap();

    public Entry(ResolverConfiguration config, URI baseURI, String id) {
        this.id = id;
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("Base URI of catalog entry must be absolute: " + baseURI);
        }
        this.baseURI = baseURI;
        this.config = config;
        this.logger = config.getFeature(ResolverFeature.RESOLVER_LOGGER);
    }

    public void setProperty(String name, String value) {
        if (NCNAME_RE.matcher(name).matches()) {
            this.extra.put(name, value);
        } else {
            this.logger.log("error", "Property name invalid: " + name, new Object[0]);
        }
    }

    public void setProperties(Map<String, String> props) {
        for (String key : props.keySet()) {
            this.setProperty(key, props.get(key));
        }
    }

    public String getProperty(String name) {
        return this.extra.get(name);
    }

    public Map<String, String> getProperties() {
        return this.extra;
    }

    public abstract Type getType();

    public static enum Type {
        NULL,
        CATALOG,
        DELEGATE_PUBLIC,
        DELEGATE_SYSTEM,
        DELEGATE_URI,
        DOCTYPE,
        DOCUMENT,
        DTD_DECL,
        ENTITY,
        GROUP,
        LINKTYPE,
        NEXT_CATALOG,
        NOTATION,
        PUBLIC,
        REWRITE_SYSTEM,
        REWRITE_URI,
        SGML_DECL,
        SYSTEM,
        SYSTEM_SUFFIX,
        URI,
        URI_SUFFIX;

    }
}

