/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.memory.management.MemoryManagementService;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.ArtifactContextFactory;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationUtils;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesHierarchyBuilder;
import org.mule.runtime.config.api.properties.ConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.ApplicationFilteredFromPolicyArtifactAst;
import org.mule.runtime.config.internal.DefaultComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.artifact.SpringArtifactContext;
import org.mule.runtime.config.internal.context.BaseConfigurationComponentLocator;
import org.mule.runtime.config.internal.context.BaseMuleArtifactContext;
import org.mule.runtime.config.internal.context.MuleArtifactContext;
import org.mule.runtime.config.internal.context.lazy.LazyMuleArtifactContext;
import org.mule.runtime.config.internal.model.ComponentBuildingDefinitionRegistryFactory;
import org.mule.runtime.config.internal.model.ComponentModelInitializer;
import org.mule.runtime.config.internal.registry.BaseSpringRegistry;
import org.mule.runtime.config.internal.registry.CompositeOptionalObjectsController;
import org.mule.runtime.config.internal.registry.DefaultOptionalObjectsController;
import org.mule.runtime.config.internal.registry.OptionalObjectsController;
import org.mule.runtime.config.internal.registry.SpringRegistry;
import org.mule.runtime.config.internal.resolvers.ConfigurationDependencyResolver;
import org.mule.runtime.core.api.Injector;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.core.api.config.builders.AbstractResourceConfigurationBuilder;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.config.ParentMuleContextAwareConfigurationBuilder;
import org.mule.runtime.core.internal.config.RuntimeLockFactoryUtil;
import org.mule.runtime.core.internal.context.DefaultMuleContext;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.core.internal.context.NullDomainMuleContextLifecycleStrategy;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeLocator;
import org.mule.runtime.core.internal.exception.ContributedErrorTypeRepository;
import org.mule.runtime.core.internal.lifecycle.LifecycleStrategy;
import org.mule.runtime.core.internal.registry.Registry;
import org.mule.runtime.deployment.model.api.artifact.ArtifactContext;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.internal.memory.management.ArtifactMemoryManagementService;
import org.mule.runtime.internal.memory.management.DefaultMemoryManagementService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

@Deprecated
public class SpringXmlConfigurationBuilder
extends AbstractResourceConfigurationBuilder
implements ParentMuleContextAwareConfigurationBuilder,
ArtifactContextFactory {
    private MemoryManagementService memoryManagementService;
    private ArtifactDeclaration artifactDeclaration;
    private boolean enableLazyInit = false;
    private boolean disableXmlValidations = false;
    private ArtifactAst parentArtifactAst;
    private ApplicationContext parentContext;
    private MuleArtifactContext muleArtifactContext;
    private final ArtifactType artifactType;
    private final LockFactory runtimeLockFactory;
    private final ComponentBuildingDefinitionRegistryFactory componentBuildingDefinitionRegistryFactory = new DefaultComponentBuildingDefinitionRegistryFactory();

    private SpringXmlConfigurationBuilder(String[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, boolean disableXmlValidations, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService) throws ConfigurationException {
        super(configResources, artifactProperties);
        this.artifactType = artifactType;
        this.enableLazyInit = enableLazyInit;
        this.disableXmlValidations = disableXmlValidations;
        this.runtimeLockFactory = runtimeLockFactory;
        this.memoryManagementService = memoryManagementService;
    }

    public SpringXmlConfigurationBuilder(String[] configResources, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInit, boolean disableXmlValidations) throws ConfigurationException {
        this(configResources, artifactProperties, artifactType, enableLazyInit, disableXmlValidations, RuntimeLockFactoryUtil.getRuntimeLockFactory(), (MemoryManagementService)DefaultMemoryManagementService.getInstance());
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String configResources, Map<String, String> artifactProperties, ArtifactType artifactType) throws ConfigurationException {
        this(new String[]{configResources}, artifactProperties, artifactType, false, false);
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String configResource) throws ConfigurationException {
        this(configResource, Collections.emptyMap(), ArtifactType.APP);
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String[] configFiles, Map<String, String> artifactProperties) throws ConfigurationException {
        this(configFiles, artifactProperties, ArtifactType.APP, false, false);
    }

    @Deprecated
    public SpringXmlConfigurationBuilder(String[] configFiles, boolean enableLazyInit, boolean disableXmlValidations) throws ConfigurationException {
        this(configFiles, Collections.emptyMap(), ArtifactType.APP, enableLazyInit, disableXmlValidations, RuntimeLockFactoryUtil.getRuntimeLockFactory(), (MemoryManagementService)DefaultMemoryManagementService.getInstance());
    }

    public SpringXmlConfigurationBuilder(String[] configurationFiles, ArtifactDeclaration artifactDeclaration, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInitialisation, boolean disableXmlValidations, LockFactory runtimeLockFactory) throws ConfigurationException {
        this(configurationFiles, artifactProperties, artifactType, enableLazyInitialisation, disableXmlValidations, runtimeLockFactory, (MemoryManagementService)DefaultMemoryManagementService.getInstance());
        this.artifactDeclaration = artifactDeclaration;
    }

    public SpringXmlConfigurationBuilder(String[] configurationFiles, ArtifactDeclaration artifactDeclaration, Map<String, String> artifactProperties, ArtifactType artifactType, boolean enableLazyInitialisation, boolean disableXmlValidations, LockFactory runtimeLockFactory, MemoryManagementService memoryManagementService) throws ConfigurationException {
        this(configurationFiles, artifactDeclaration, artifactProperties, artifactType, enableLazyInitialisation, disableXmlValidations, runtimeLockFactory);
        this.memoryManagementService = memoryManagementService;
    }

    protected void doConfigure(MuleContext muleContext) throws Exception {
        if (ArrayUtils.isEmpty((Object[])this.artifactConfigResources) && this.artifactType == ArtifactType.DOMAIN) {
            ((DefaultMuleContext)muleContext).setLifecycleStrategy((LifecycleStrategy)new NullDomainMuleContextLifecycleStrategy());
            return;
        }
        LifecycleUtils.initialiseIfNeeded((Object)this, (MuleContext)muleContext);
        OptionalObjectsController applicationObjectController = this.createApplicationObjectController();
        Optional<ConfigurationProperties> parentConfigurationProperties = this.resolveParentConfigurationProperties();
        BaseMuleArtifactContext baseMuleArtifactContext = this.createBaseContext(muleContext, applicationObjectController, parentConfigurationProperties);
        this.serviceConfigurators.forEach(serviceConfigurator -> serviceConfigurator.configure(muleContext.getCustomizationService()));
        this.createBaseRegistry(muleContext, baseMuleArtifactContext);
        this.muleArtifactContext = this.createApplicationContext(muleContext, applicationObjectController, parentConfigurationProperties, (BaseConfigurationComponentLocator)baseMuleArtifactContext.getBean(BaseConfigurationComponentLocator.class), (ContributedErrorTypeRepository)baseMuleArtifactContext.getBean(ContributedErrorTypeRepository.class), (ContributedErrorTypeLocator)baseMuleArtifactContext.getBean(ContributedErrorTypeLocator.class), (FeatureFlaggingService)baseMuleArtifactContext.getBean(FeatureFlaggingService.class), (ExpressionLanguageMetadataService)baseMuleArtifactContext.getBean(ExpressionLanguageMetadataService.class));
        this.muleArtifactContext.setParent((ApplicationContext)baseMuleArtifactContext);
        this.createSpringRegistry((DefaultMuleContext)muleContext, (ApplicationContext)baseMuleArtifactContext, this.muleArtifactContext);
    }

    private BaseMuleArtifactContext createBaseContext(MuleContext muleContext, OptionalObjectsController applicationObjectController, Optional<ConfigurationProperties> parentConfigurationProperties) {
        BaseMuleArtifactContext baseMuleArtifactContext = new BaseMuleArtifactContext(muleContext, applicationObjectController, parentConfigurationProperties, this.getArtifactProperties(), this.artifactType, this.enableLazyInit);
        if (baseMuleArtifactContext instanceof ConfigurableApplicationContext) {
            baseMuleArtifactContext.setParent(this.parentContext);
        }
        return baseMuleArtifactContext;
    }

    private BaseSpringRegistry createBaseRegistry(MuleContext muleContext, BaseMuleArtifactContext baseMuleArtifactContext) throws InitialisationException {
        BaseSpringRegistry baseRegistry = new BaseSpringRegistry((ApplicationContext)baseMuleArtifactContext, muleContext, ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
        ((DefaultMuleContext)muleContext).setRegistry((Registry)baseRegistry);
        ((DefaultMuleContext)muleContext).setInjector((Injector)baseRegistry);
        baseRegistry.initialise();
        return baseRegistry;
    }

    protected void addResources(List<ConfigResource> allResources) {
    }

    private MuleArtifactContext createApplicationContext(MuleContext muleContext, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, FeatureFlaggingService featureFlaggingService, ExpressionLanguageMetadataService expressionLanguageMetadataService) throws Exception {
        return this.doCreateApplicationContext(muleContext, this.artifactDeclaration, optionalObjectsController, parentConfigurationProperties, baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, featureFlaggingService, expressionLanguageMetadataService);
    }

    protected OptionalObjectsController createApplicationObjectController() {
        OptionalObjectsController applicationObjectcontroller = new DefaultOptionalObjectsController();
        OptionalObjectsController parentObjectController = null;
        if (this.parentContext instanceof MuleArtifactContext) {
            parentObjectController = ((MuleArtifactContext)this.parentContext).getOptionalObjectsController();
        }
        if (parentObjectController != null) {
            applicationObjectcontroller = new CompositeOptionalObjectsController(applicationObjectcontroller, parentObjectController);
        }
        return applicationObjectcontroller;
    }

    private MuleArtifactContext doCreateApplicationContext(MuleContext muleContext, ArtifactDeclaration artifactDeclaration, OptionalObjectsController optionalObjectsController, Optional<ConfigurationProperties> parentConfigurationProperties, BaseConfigurationComponentLocator baseConfigurationComponentLocator, ContributedErrorTypeRepository errorTypeRepository, ContributedErrorTypeLocator errorTypeLocator, FeatureFlaggingService featureFlaggingService, ExpressionLanguageMetadataService expressionLanguageMetadataService) {
        MuleArtifactContext muleArtifactContext;
        ArtifactAst artifactAst = this.createApplicationModel(this.getExtensions(muleContext.getExtensionManager()), artifactDeclaration, this.resolveArtifactConfigResources(), this.getArtifactProperties(), this.disableXmlValidations, featureFlaggingService);
        if (this.enableLazyInit) {
            muleArtifactContext = new LazyMuleArtifactContext(muleContext, artifactAst, optionalObjectsController, parentConfigurationProperties, baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, this.getArtifactProperties(), true, this.artifactType, this.resolveComponentModelInitializer(), this.runtimeLockFactory, this.componentBuildingDefinitionRegistryFactory, (MemoryManagementService)new ArtifactMemoryManagementService(this.memoryManagementService), featureFlaggingService, expressionLanguageMetadataService);
        } else {
            muleArtifactContext = new MuleArtifactContext(muleContext, artifactAst, optionalObjectsController, parentConfigurationProperties, baseConfigurationComponentLocator, errorTypeRepository, errorTypeLocator, this.getArtifactProperties(), true, this.artifactType, this.componentBuildingDefinitionRegistryFactory, (MemoryManagementService)new ArtifactMemoryManagementService(this.memoryManagementService), featureFlaggingService, expressionLanguageMetadataService);
            muleArtifactContext.initialize();
        }
        return muleArtifactContext;
    }

    private Set<ExtensionModel> getExtensions(ExtensionManager extensionManager) {
        return extensionManager == null ? Collections.emptySet() : extensionManager.getExtensions();
    }

    private ArtifactAst createApplicationModel(Set<ExtensionModel> extensions, ArtifactDeclaration artifactDeclaration, ConfigResource[] artifactConfigResources, Map<String, String> artifactProperties, boolean disableXmlValidations, FeatureFlaggingService featureFlaggingService) {
        try {
            ArtifactAst artifactAst;
            if (artifactDeclaration == null) {
                if (artifactConfigResources.length == 0) {
                    artifactAst = MuleAstUtils.emptyArtifact();
                } else {
                    AstXmlParser parser = this.createMuleXmlParser(extensions, artifactProperties, disableXmlValidations, featureFlaggingService);
                    artifactAst = parser.parse(artifactConfigResources);
                }
            } else {
                artifactAst = ArtifactDeclarationUtils.toArtifactast(artifactDeclaration, extensions);
            }
            return artifactAst;
        }
        catch (MuleRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private AstXmlParser createMuleXmlParser(Set<ExtensionModel> extensions, Map<String, String> artifactProperties, boolean disableXmlValidations, FeatureFlaggingService featureFlaggingService) {
        ConfigurationPropertiesResolver propertyResolver = new ConfigurationPropertiesHierarchyBuilder().withApplicationProperties(artifactProperties).build();
        AstXmlParser.Builder builder = AstXmlParser.builder().withPropertyResolver(propertyKey -> (String)propertyResolver.resolveValue(propertyKey)).withExtensionModels(extensions).withParentArtifact(this.resolveParentArtifact(featureFlaggingService));
        if (!featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR)) {
            builder.withLegacyFailStrategy();
        }
        if (disableXmlValidations) {
            builder.withSchemaValidationsDisabled();
        }
        switch (this.artifactType) {
            case APP: {
                builder.withArtifactType(org.mule.runtime.ast.api.ArtifactType.APPLICATION);
                break;
            }
            case DOMAIN: {
                builder.withArtifactType(org.mule.runtime.ast.api.ArtifactType.DOMAIN);
                break;
            }
            case POLICY: {
                builder.withArtifactType(org.mule.runtime.ast.api.ArtifactType.POLICY);
                break;
            }
        }
        return builder.build();
    }

    protected ArtifactAst resolveParentArtifact(FeatureFlaggingService featureFlaggingService) {
        if (ArtifactType.POLICY.equals((Object)this.artifactType)) {
            return ApplicationFilteredFromPolicyArtifactAst.applicationFilteredFromPolicyArtifactAst(this.parentArtifactAst, featureFlaggingService);
        }
        return this.parentArtifactAst;
    }

    private ConfigResource[] resolveArtifactConfigResources() {
        return this.artifactConfigResources;
    }

    private Optional<ConfigurationProperties> resolveParentConfigurationProperties() {
        Optional<ConfigurationProperties> parentConfigurationProperties = Optional.empty();
        if (this.parentContext != null) {
            parentConfigurationProperties = Optional.of((ConfigurationProperties)this.parentContext.getBean(ConfigurationProperties.class));
        }
        return parentConfigurationProperties;
    }

    private Optional<ComponentModelInitializer> resolveComponentModelInitializer() {
        Optional<ComponentModelInitializer> parentLazyComponentInitializer = Optional.empty();
        if (this.parentContext != null && this.parentContext instanceof ComponentModelInitializer) {
            parentLazyComponentInitializer = Optional.of((ComponentModelInitializer)this.parentContext);
        }
        return parentLazyComponentInitializer;
    }

    private void createSpringRegistry(DefaultMuleContext muleContext, ApplicationContext baseApplicationContext, MuleArtifactContext applicationContext) throws Exception {
        SpringRegistry registry = this.parentContext != null ? this.createRegistryWithParentContext((MuleContext)muleContext, baseApplicationContext, applicationContext, this.parentContext) : new SpringRegistry(baseApplicationContext, (ApplicationContext)applicationContext, (MuleContext)muleContext, new ConfigurationDependencyResolver(applicationContext.getApplicationModel()), muleContext.getLifecycleInterceptor());
        muleContext.setRegistry((Registry)registry);
        muleContext.setInjector((Injector)registry);
    }

    private SpringRegistry createRegistryWithParentContext(MuleContext muleContext, ApplicationContext baseApplicationContext, MuleArtifactContext applicationContext, ApplicationContext parentContext) throws ConfigurationException {
        if (baseApplicationContext instanceof ConfigurableApplicationContext) {
            return new SpringRegistry(baseApplicationContext, (ApplicationContext)applicationContext, muleContext, new ConfigurationDependencyResolver(applicationContext.getApplicationModel()), ((DefaultMuleContext)muleContext).getLifecycleInterceptor());
        }
        throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Cannot set a parent context if the ApplicationContext does not implement ConfigurableApplicationContext"));
    }

    protected synchronized void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
        if (lifecycleManager.isPhaseComplete("start")) {
            lifecycleManager.fireLifecycle("start");
        }
    }

    @Override
    public ArtifactContext createArtifactContext() {
        return new SpringArtifactContext(this.muleArtifactContext);
    }

    public void setParentContext(MuleContext domainContext, ArtifactAst parentAst) {
        this.parentContext = (ApplicationContext)((MuleContextWithRegistry)domainContext).getRegistry().get("springApplicationContext");
        this.parentArtifactAst = parentAst;
    }
}

