/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.service.http.netty.impl.client.ContextHttpClientConnectionFactory;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.util.SslContextHelper;

public class HttpClientConnectionManager
implements ContextHttpClientConnectionFactory,
Disposable,
Initialisable {
    private static final int CLIENT_SELECTOR_THREAD_COUNT = Integer.getInteger("mule.http.client.selectors.count", Integer.max(Runtime.getRuntime().availableProcessors(), 2));
    private final SchedulerService schedulerService;
    private final Map<String, HttpClient> clients = new ConcurrentHashMap<String, HttpClient>();
    private Scheduler selectorScheduler;
    private Scheduler dnsEventLoopScheduler;

    public HttpClientConnectionManager(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    protected HttpClientConnectionManager() {
        this(null);
    }

    public HttpClient getOrCreateClient(String name, Supplier<? extends HttpClientConfiguration> configuration) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (String)"Client name can't be null");
        return this.clients.computeIfAbsent(name, serverName -> this.create((HttpClientConfiguration)configuration.get()));
    }

    @Override
    public HttpClient create(HttpClientConfiguration configuration) {
        try {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"Client configuration can't be null");
            NettyHttpClient.Builder builder = NettyHttpClient.builder().withProxyConfig(configuration.getProxyConfig()).withSslContext(SslContextHelper.sslContextForClient(configuration.getTlsContextFactory())).withConnectionIdleTimeout(configuration.getConnectionIdleTimeout()).withUsingPersistentConnections(configuration.isUsePersistentConnections()).withSelectorsScheduler(this.selectorScheduler).withSelectorsCount(CLIENT_SELECTOR_THREAD_COUNT).withMaxConnections(configuration.getMaxConnections()).withDnsEventLoopScheduler(this.dnsEventLoopScheduler);
            return this.enrichClientBuilder(builder, configuration).build();
        }
        catch (IllegalArgumentException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private Scheduler createSelectorsScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(CLIENT_SELECTOR_THREAD_COUNT).withName("http.requester"), 0);
    }

    private Scheduler createDnsEventLoopScheduler() {
        if (this.schedulerService == null) {
            return null;
        }
        return this.schedulerService.ioScheduler();
    }

    protected NettyHttpClient.Builder enrichClientBuilder(NettyHttpClient.Builder builder, HttpClientConfiguration configuration) {
        return builder;
    }

    public void dispose() {
        if (this.selectorScheduler != null) {
            this.selectorScheduler.shutdown();
            this.selectorScheduler = null;
        }
        if (this.dnsEventLoopScheduler != null) {
            this.dnsEventLoopScheduler.shutdown();
            this.dnsEventLoopScheduler = null;
        }
    }

    public void initialise() throws InitialisationException {
        this.selectorScheduler = this.createSelectorsScheduler();
        this.dnsEventLoopScheduler = this.createDnsEventLoopScheduler();
    }
}

