/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.impl.commons.nodes.ParametrizedReferenceNode;
import org.raml.v2.internal.impl.commons.suggester.ReferenceSuggester;
import org.raml.yagi.framework.grammar.rule.ObjectRule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class ParametrizedNodeReferenceRule
extends ObjectRule {
    private ReferenceSuggester suggester;

    public ParametrizedNodeReferenceRule(String referenceKey) {
        this.suggester = new ReferenceSuggester(referenceKey);
    }

    public boolean matches(@Nonnull Node node) {
        return super.matches(node) && this.hasOneKey(node) || node instanceof ParametrizedReferenceNode;
    }

    private boolean hasOneKey(@Nonnull Node node) {
        return !node.getChildren().isEmpty() && !((Node)node.getChildren().get(0)).getChildren().isEmpty();
    }

    public List<Suggestion> getSuggestions(List<Node> pathToRoot, ParsingContext context) {
        switch (pathToRoot.size()) {
            case 1: {
                return this.getSuggestions(pathToRoot.get(0), context);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        if (this.hasOneKey(node)) {
            Node key = (Node)((Node)node.getChildren().get(0)).getChildren().get(0);
            return this.suggester.getSuggestions(key);
        }
        return super.getSuggestions(node, context);
    }

    protected Node getResult(Node node) {
        if (node instanceof ParametrizedReferenceNode) {
            return node;
        }
        String arg = ((Node)((Node)node.getChildren().get(0)).getChildren().get(0)).toString();
        return this.createNodeUsingFactory(node, new Object[]{arg});
    }

    public String getDescription() {
        return "Parametrized reference call.";
    }
}

