/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.message.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalLong;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.service.http.netty.impl.message.content.Feedable;

public class BaseHttpEntity
implements Feedable,
HttpEntity {
    private static final int ENTITY_PIPE_SIZE = 102400;
    private final PipedOutputStream sinkForReceivedData = new PipedOutputStream();
    private final PipedInputStream asInputStream;
    private boolean isClosed;
    private long partialLength;

    public BaseHttpEntity() {
        try {
            this.asInputStream = new PipedInputStream(this.sinkForReceivedData, 102400);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.partialLength = 0L;
        this.isClosed = false;
    }

    @Override
    public void feed(byte[] data, int offset, int size) throws IOException {
        this.sinkForReceivedData.write(data, offset, size);
        this.partialLength += (long)size;
    }

    @Override
    public void close() throws IOException {
        this.sinkForReceivedData.close();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isEmpty() {
        return this.isClosed && this.partialLength == 0L;
    }

    public boolean isStreaming() {
        return false;
    }

    public boolean isComposed() {
        return false;
    }

    public InputStream getContent() {
        return this.asInputStream;
    }

    public byte[] getBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.asInputStream);
    }

    public Collection<HttpPart> getParts() throws IOException {
        return null;
    }

    public Optional<Long> getLength() {
        if (this.isClosed) {
            return Optional.of(this.partialLength);
        }
        return Optional.empty();
    }

    public OptionalLong getBytesLength() {
        if (this.isClosed) {
            return OptionalLong.of(this.partialLength);
        }
        return OptionalLong.empty();
    }
}

