/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.util;

import io.netty.handler.codec.http.QueryStringEncoder;
import java.net.URI;
import org.mule.runtime.api.util.MultiMap;

public final class HttpUtils {
    public static final String QUERY_STRING_DELIMITER = "\\?";
    public static final String QUERY_PARAMS_SEPARATOR = "&";
    public static final String QUERY_PARAM_VALUE_DELIMITER = "=";

    private HttpUtils() {
    }

    public static String buildUriString(URI uri, MultiMap<String, String> queryParams) {
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("The uri provided '" + uri + "' must contain a scheme.");
        }
        if (uri.getHost() == null) {
            throw new IllegalArgumentException("The uri provided '" + uri + "' must contain a host.");
        }
        String uriAsString = uri.toASCIIString();
        if (queryParams == null || queryParams.isEmpty()) {
            return uriAsString;
        }
        String[] splitUri = uriAsString.split(QUERY_STRING_DELIMITER);
        QueryStringEncoder encoder = new QueryStringEncoder(splitUri[0]);
        if (splitUri.length > 1) {
            String[] uriQueryParams;
            for (String param : uriQueryParams = splitUri[1].split(QUERY_PARAMS_SEPARATOR)) {
                String[] keyValueParam = param.split(QUERY_PARAM_VALUE_DELIMITER);
                encoder.addParam(keyValueParam[0], keyValueParam.length > 1 ? keyValueParam[1] : null);
            }
        }
        for (String key : queryParams.keySet()) {
            for (String value : queryParams.getAll((Object)key)) {
                encoder.addParam(key, value);
            }
        }
        return encoder.toString();
    }
}

