/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;
import org.mule.metadata.internal.utils.IoUtils;

public class SchemaCollector {
    private final Map<String, InputStream> schemas;
    private final String charset;

    private SchemaCollector(String charset) {
        this.charset = charset;
        this.schemas = new LinkedHashMap<String, InputStream>();
    }

    public static SchemaCollector getInstance() {
        return new SchemaCollector(Charset.defaultCharset().toString());
    }

    public static SchemaCollector getInstance(String charset) {
        return new SchemaCollector(charset);
    }

    public SchemaCollector addSchema(File schema) {
        try {
            this.schemas.put(schema.toURI().toString(), this.wrapInBOMInputStream(new FileInputStream(schema)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Error while adding schema file [" + schema.getName() + "]", e);
        }
        return this;
    }

    public SchemaCollector addSchema(URL schemaUrl) {
        try {
            this.schemas.put(schemaUrl.toString(), this.wrapInBOMInputStream(IoUtils.getInputStreamWithCacheControl((URL)schemaUrl)));
        }
        catch (IOException e) {
            throw new RuntimeException("Error while adding schema of URL [" + schemaUrl + "]", e);
        }
        return this;
    }

    public SchemaCollector addSchema(String name, String schemaContent) {
        this.schemas.put(name, this.wrapInBOMInputStream(new ByteArrayInputStream(schemaContent.getBytes(Charset.forName(this.charset)))));
        return this;
    }

    public SchemaCollector addSchema(String schemaUrl) {
        try {
            this.addSchema(new URL(schemaUrl));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("The specified URL [" + schemaUrl + "] is invalid", e);
        }
        return this;
    }

    public SchemaCollector addSchema(String name, InputStream schemaContent) {
        this.schemas.put(name, this.wrapInBOMInputStream(schemaContent));
        return this;
    }

    public Map<String, InputStream> collect() {
        return Collections.unmodifiableMap(this.schemas);
    }

    private InputStream wrapInBOMInputStream(InputStream streamToWrap) {
        return new BOMInputStream(streamToWrap);
    }
}

