/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;

public class Count
extends SystemFunction {
    @Override
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.ZERO, Expression.MAX_SEQUENCE_LENGTH};
    }

    public static int count(SequenceIterator iter) throws XPathException {
        if (SequenceTool.supportsGetLength(iter)) {
            return SequenceTool.getLength(iter);
        }
        int n = 0;
        while (iter.next() != null) {
            ++n;
        }
        return n;
    }

    public static int steppingCount(SequenceIterator iter) {
        int n = 0;
        while (iter.next() != null) {
            ++n;
        }
        return n;
    }

    @Override
    public IntegerValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        Sequence arg = arguments[0];
        int size = arg instanceof GroundedValue ? ((GroundedValue)arg).getLength() : Count.count(arg.iterate());
        return Int64Value.makeIntegerValue(size);
    }

    @Override
    public String getStreamerName() {
        return "Count";
    }

    @Override
    public Elaborator getElaborator() {
        return new CountFnElaborator();
    }

    public static class CountFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            PullEvaluator puller = arg.makeElaborator().elaborateForPull();
            return context -> Int64Value.makeIntegerValue(Count.count(puller.iterate(context)));
        }
    }
}

