/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.lazy;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.runtime.config.internal.context.lazy.ComponentInitializationState;
import org.mule.runtime.core.api.config.ConfigurationException;

class ComponentInitializationRequest {
    private final ArtifactAstDependencyGraph postProcessedGraph;
    private final ArtifactAstDependencyGraph baseGraph;
    private final ComponentInitializationState componentInitializationState;
    private final Predicate<ComponentAst> alwaysEnabledComponentPredicate;
    private final Optional<Location> location;
    private final Predicate<ComponentAst> componentFilter;
    private final boolean isApplyStartPhaseRequested;
    private final boolean isKeepPrevious;
    private ArtifactAst postProcessedMinimalArtifactAst;
    private ArtifactAst baseMinimalArtifactAst;
    private ArtifactAst artifactAstToInitialize;
    private Set<String> requestedLocations;

    private ComponentInitializationRequest(ArtifactAstDependencyGraph postProcessedGraph, ArtifactAstDependencyGraph baseGraph, ComponentInitializationState componentInitializationState, Predicate<ComponentAst> alwaysEnabledComponentPredicate, Predicate<ComponentAst> componentFilter, Optional<Location> location, boolean applyStartPhase, boolean keepPrevious) {
        this.postProcessedGraph = postProcessedGraph;
        this.baseGraph = baseGraph;
        this.componentInitializationState = componentInitializationState;
        this.alwaysEnabledComponentPredicate = alwaysEnabledComponentPredicate;
        this.location = location;
        this.componentFilter = componentFilter;
        this.isApplyStartPhaseRequested = applyStartPhase;
        this.isKeepPrevious = keepPrevious;
    }

    public Optional<Location> getLocation() {
        return this.location;
    }

    public boolean isApplyStartPhaseRequested() {
        return this.isApplyStartPhaseRequested;
    }

    public boolean isKeepPreviousRequested() {
        return this.isKeepPrevious;
    }

    public Set<String> getRequestedLocations() {
        if (this.requestedLocations == null) {
            this.requestedLocations = this.doGetRequestedLocations(this.getPostProcessedMinimalArtifactAst());
        }
        return this.requestedLocations;
    }

    public void validateRequestedAst(ArtifactAstValidator astValidator) throws ConfigurationException {
        astValidator.validate(this.getBaseMinimalArtifactAst());
    }

    private ArtifactAst getBaseMinimalArtifactAst() {
        if (this.baseMinimalArtifactAst == null) {
            Predicate<ComponentAst> minimalApplicationFilter = this.getFilterForMinimalArtifactAst();
            return this.baseGraph.minimalArtifactFor(minimalApplicationFilter);
        }
        return this.baseMinimalArtifactAst;
    }

    public ArtifactAst getFilteredAstToInitialize() {
        if (this.artifactAstToInitialize == null) {
            this.artifactAstToInitialize = this.doGetFilteredAstToInitialize(this.getPostProcessedMinimalArtifactAst());
        }
        return this.artifactAstToInitialize;
    }

    private static Predicate<ComponentAst> buildFilterFromComponentLocationFilter(LazyComponentInitializer.ComponentLocationFilter locationFilter) {
        return componentModel -> {
            if (componentModel.getLocation() != null) {
                return locationFilter.accept(componentModel.getLocation());
            }
            return false;
        };
    }

    private static Predicate<ComponentAst> buildFilterFromLocation(Location location) {
        return comp -> comp.getLocation() != null && comp.getLocation().getLocation().equals(location.toString());
    }

    private ArtifactAst getPostProcessedMinimalArtifactAst() {
        if (this.postProcessedMinimalArtifactAst == null) {
            this.postProcessedMinimalArtifactAst = this.doGetPostProcessedMinimalArtifactAst();
        }
        return this.postProcessedMinimalArtifactAst;
    }

    private ArtifactAst doGetPostProcessedMinimalArtifactAst() {
        Predicate<ComponentAst> minimalApplicationFilter = this.getFilterForMinimalArtifactAst();
        return this.postProcessedGraph.minimalArtifactFor(minimalApplicationFilter);
    }

    private Predicate<ComponentAst> getFilterForMinimalArtifactAst() {
        if (this.isKeepPreviousRequested()) {
            return this.componentFilter;
        }
        return this.componentFilter.or(this.alwaysEnabledComponentPredicate);
    }

    private Set<String> doGetRequestedLocations(ArtifactAst artifactAst) {
        return this.getLocation().map(location -> Collections.singleton(location.toString())).orElseGet(() -> artifactAst.filteredComponents(this.componentFilter).map(comp -> comp.getLocation().getLocation()).collect(Collectors.toSet()));
    }

    private ArtifactAst doGetFilteredAstToInitialize(ArtifactAst artifactAst) {
        if (this.isKeepPreviousRequested()) {
            return MuleAstUtils.filteredArtifactAst((ArtifactAst)artifactAst, comp -> !this.componentInitializationState.isComponentAlreadyInitialized((ComponentAst)comp));
        }
        return artifactAst;
    }

    public static class Builder {
        private final ArtifactAstDependencyGraph postProcessedGraph;
        private final ComponentInitializationState componentInitializationState;
        private final Predicate<ComponentAst> alwaysEnabledComponentPredicate;
        private final boolean applyStartPhase;
        private final boolean keepPrevious;
        private final ArtifactAstDependencyGraph baseGraph;

        public Builder(ArtifactAstDependencyGraph postProcessedGraph, ArtifactAstDependencyGraph baseGraph, ComponentInitializationState componentInitializationState, Predicate<ComponentAst> alwaysEnabledComponentPredicate, boolean applyStartPhase, boolean keepPrevious) {
            this.postProcessedGraph = postProcessedGraph;
            this.baseGraph = baseGraph;
            this.componentInitializationState = componentInitializationState;
            this.alwaysEnabledComponentPredicate = alwaysEnabledComponentPredicate;
            this.applyStartPhase = applyStartPhase;
            this.keepPrevious = keepPrevious;
        }

        public ComponentInitializationRequest build(Location location) {
            return new ComponentInitializationRequest(this.postProcessedGraph, this.baseGraph, this.componentInitializationState, this.alwaysEnabledComponentPredicate, ComponentInitializationRequest.buildFilterFromLocation(location), Optional.of(location), this.applyStartPhase, this.keepPrevious);
        }

        public ComponentInitializationRequest build(Predicate<ComponentAst> componentFilter) {
            return new ComponentInitializationRequest(this.postProcessedGraph, this.baseGraph, this.componentInitializationState, this.alwaysEnabledComponentPredicate, componentFilter, Optional.empty(), this.applyStartPhase, this.keepPrevious);
        }

        public ComponentInitializationRequest build(LazyComponentInitializer.ComponentLocationFilter componentLocationFilter) {
            return this.build(ComponentInitializationRequest.buildFilterFromComponentLocationFilter(componentLocationFilter));
        }
    }

    @FunctionalInterface
    public static interface ArtifactAstValidator {
        public void validate(ArtifactAst var1) throws ConfigurationException;
    }
}

