/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.metadata;

import java.util.Objects;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MapDataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.privileged.metadata.SimpleDataType;

@NoExtend
public class DefaultMapDataType
extends SimpleDataType
implements MapDataType {
    private static final long serialVersionUID = 1052687171949146300L;
    private final DataType keyType;
    private final DataType valueType;

    protected DefaultMapDataType(Class<?> type, DataType keyType, DataType valueType, MediaType mimeType, boolean streamType) {
        super(type, mimeType, streamType);
        this.keyType = keyType;
        this.valueType = valueType;
    }

    @Override
    public boolean isCompatibleWith(DataType dataType) {
        if (dataType instanceof DataType.DynamicDelegateDataType) {
            dataType = ((DataType.DynamicDelegateDataType)dataType).getDelegate();
        }
        if (!(dataType instanceof DefaultMapDataType)) {
            return false;
        }
        if (!super.isCompatibleWith(dataType)) {
            return false;
        }
        DefaultMapDataType that = (DefaultMapDataType)dataType;
        return this.getKeyDataType().isCompatibleWith(that.getKeyDataType()) && this.getValueDataType().isCompatibleWith(that.getValueDataType());
    }

    public DataType getKeyDataType() {
        return this.keyType;
    }

    public DataType getValueDataType() {
        return this.valueType;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DataType.DynamicDelegateDataType) {
            o = ((DataType.DynamicDelegateDataType)o).getDelegate();
        }
        if (this == o) {
            return true;
        }
        if (o == null || !this.equalsCheckClass(o)) {
            return false;
        }
        DefaultMapDataType that = (DefaultMapDataType)o;
        return Objects.equals(this.getKeyDataType(), that.getKeyDataType()) && Objects.equals(this.getValueDataType(), that.getValueDataType()) && Objects.equals(this.getType(), that.getType()) && Objects.equals(this.getMediaType(), that.getMediaType());
    }

    @Override
    protected boolean equalsCheckClass(Object o) {
        return this.getClass() == o.getClass() || DefaultMapDataType.class.isAssignableFrom(o.getClass());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.getKeyDataType(), this.getValueDataType(), this.getMediaType());
    }

    @Override
    public String toString() {
        return "MapDataType{type=" + this.getType().getName() + ", keyType=" + this.getKeyDataType().toString() + ", valueType=" + this.getValueDataType().toString() + ", mimeType='" + this.getMediaType() + '\'' + '}';
    }
}

