/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader;

import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.api.annotation.NoExtend;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.FilteringArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;

@NoExtend
@NoInstantiate
public class MuleDeployableArtifactClassLoader
extends MuleArtifactClassLoader {
    public MuleDeployableArtifactClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        super(artifactId, artifactDescriptor, urls, parent, lookupPolicy);
    }

    @Deprecated
    public MuleDeployableArtifactClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy, List<ArtifactClassLoader> artifactPluginClassLoaders) {
        super(artifactId, artifactDescriptor, urls, parent, lookupPolicy);
    }

    public List<ArtifactClassLoader> getArtifactPluginClassLoaders() {
        return ((RegionClassLoader)this.getParent()).getArtifactPluginClassLoaders().stream().map(fcl -> fcl instanceof FilteringArtifactClassLoader ? ((FilteringArtifactClassLoader)fcl).getArtifactClassLoader() : fcl).collect(Collectors.toList());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (MuleDeployableArtifactClassLoader.isRegionClassLoaderMember(this)) {
            ((RegionClassLoader)this.getParent()).disposeFromOwnerClassLoader();
        }
    }

    protected static boolean isRegionClassLoaderMember(ClassLoader classLoader) {
        return !MuleDeployableArtifactClassLoader.isRegionClassLoader(classLoader) && MuleDeployableArtifactClassLoader.isRegionClassLoader(classLoader.getParent());
    }

    private static boolean isRegionClassLoader(ClassLoader classLoader) {
        return classLoader instanceof RegionClassLoader;
    }

    static {
        MuleDeployableArtifactClassLoader.registerAsParallelCapable();
    }
}

