/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.core.json.reader.indexed;

import java.io.Serializable;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.core.common.LocationCacheBuilder;
import org.mule.weave.v2.module.core.json.reader.JsonTokenizer;
import org.mule.weave.v2.module.core.json.reader.indexed.JsonLocation;
import org.mule.weave.v2.module.core.json.reader.indexed.JsonRootValue$;
import org.mule.weave.v2.module.core.json.reader.indexed.JsonTokenHelper$;
import org.mule.weave.v2.module.core.json.reader.indexed.JsonTokenType$;
import org.mule.weave.v2.module.core.xml.reader.indexed.LocationCaches;
import org.mule.weave.v2.module.core.xml.reader.indexed.TokenArray;
import org.mule.weave.v2.module.core.xml.reader.indexed.TokenArray$;
import org.mule.weave.v2.module.reader.SourceReader;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001B\u0010!\u0001MB\u0001B\u0010\u0001\u0003\u0006\u0004%\te\u0010\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0001\"AA\n\u0001BC\u0002\u0013\u0005S\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003O\u0011!!\u0006A!A!\u0002\u0017)\u0006\"B.\u0001\t\u0003a\u0006bB2\u0001\u0001\u0004%I\u0001\u001a\u0005\bQ\u0002\u0001\r\u0011\"\u0003j\u0011\u0019y\u0007\u0001)Q\u0005K\"9\u0001\u000f\u0001b\u0001\n\u0013\t\bB\u0002>\u0001A\u0003%!\u000fC\u0004|\u0001\t\u0007I\u0011\u0002?\t\u000f\u0005\u001d\u0001\u0001)A\u0005{\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003c\u0001A\u0011CA\u001a\u0011\u001d\tY\u0004\u0001C\u0001\u0003{Aq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002p\u0001!I!!\u001d\t\u000f\u0005U\u0004\u0001\"\u0003\u0002x!9\u0011\u0011\u0010\u0001\u0005\n\u0005m\u0004bBA?\u0001\u0011%\u00111\u0010\u0005\b\u0003\u007f\u0002A\u0011BA>\u0011\u001d\t\t\t\u0001C\u0005\u0003wBq!a!\u0001\t+\tY\bC\u0004\u0002\u0014\u0002!\t\"!&\t\u000f\u0005]\u0005\u0001\"\u0003\u0002\u001a\"9\u0011\u0011\u001a\u0001\u0005\n\u0005m\u0004bBAf\u0001\u0011%\u00111\u0010\u0005\b\u0003\u001f\u0004A\u0011BA>\u0005QIe\u000eZ3yK\u0012T5o\u001c8U_.,g.\u001b>fe*\u0011\u0011EI\u0001\bS:$W\r_3e\u0015\t\u0019C%\u0001\u0004sK\u0006$WM\u001d\u0006\u0003K\u0019\nAA[:p]*\u0011q\u0005K\u0001\u0005G>\u0014XM\u0003\u0002*U\u00051Qn\u001c3vY\u0016T!a\u000b\u0017\u0002\u0005Y\u0014$BA\u0017/\u0003\u00159X-\u0019<f\u0015\ty\u0003'\u0001\u0003nk2,'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!$\b\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdG\u0001\u0004B]f\u0014VM\u001a\t\u0003wqj\u0011AI\u0005\u0003{\t\u0012QBS:p]R{7.\u001a8ju\u0016\u0014\u0018\u0001\u00028b[\u0016,\u0012\u0001\u0011\t\u0003\u0003\"s!A\u0011$\u0011\u0005\r3T\"\u0001#\u000b\u0005\u0015\u0013\u0014A\u0002\u001fs_>$h(\u0003\u0002Hm\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9e'A\u0003oC6,\u0007%A\u0003j]B,H/F\u0001O!\ty\u0015+D\u0001Q\u0015\t\u0019\u0003&\u0003\u0002S!\na1k\\;sG\u0016\u0014V-\u00193fe\u00061\u0011N\u001c9vi\u0002\n1a\u0019;y!\t1\u0016,D\u0001X\u0015\tA&&A\u0003n_\u0012,G.\u0003\u0002[/\n\tRI^1mk\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\ri\u0016M\u0019\u000b\u0003=\u0002\u0004\"a\u0018\u0001\u000e\u0003\u0001BQ\u0001\u0016\u0004A\u0004UCQA\u0010\u0004A\u0002\u0001CQ\u0001\u0014\u0004A\u00029\u000bQ\u0001Z3qi\",\u0012!\u001a\t\u0003k\u0019L!a\u001a\u001c\u0003\u0007%sG/A\u0005eKB$\bn\u0018\u0013fcR\u0011!.\u001c\t\u0003k-L!\u0001\u001c\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b]\"\t\t\u00111\u0001f\u0003\rAH%M\u0001\u0007I\u0016\u0004H\u000f\u001b\u0011\u0002\u0017Q|7.\u001a8Ck\u001a4WM]\u000b\u0002eB\u00111\u000f_\u0007\u0002i*\u0011\u0011%\u001e\u0006\u0003GYT!a\u001e\u0014\u0002\u0007alG.\u0003\u0002zi\nQAk\\6f]\u0006\u0013(/Y=\u0002\u0019Q|7.\u001a8Ck\u001a4WM\u001d\u0011\u0002\u00131\u001c')^5mI\u0016\u0014X#A?\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\tAJ\u0001\u0007G>lWn\u001c8\n\u0007\u0005\u0015qP\u0001\u000bM_\u000e\fG/[8o\u0007\u0006\u001c\u0007.\u001a\"vS2$WM]\u0001\u000bY\u000e\u0014U/\u001b7eKJ\u0004\u0013\u0001C1eIR{7.\u001a8\u0015\u000b)\fi!!\b\t\u000f\u0005=a\u00021\u0001\u0002\u0012\u0005)Ao\\6f]B)Q'a\u0005\u0002\u0018%\u0019\u0011Q\u0003\u001c\u0003\u000b\u0005\u0013(/Y=\u0011\u0007U\nI\"C\u0002\u0002\u001cY\u0012A\u0001T8oO\"9\u0011q\u0004\bA\u0002\u0005\u0005\u0012\u0001\u00049viR{7.\u001a8J]2\u001b\u0005cA\u001b\u0002$%\u0019\u0011Q\u0005\u001c\u0003\u000f\t{w\u000e\\3b]\u0006\t\"/Z1e'R\u0014\u0018N\\4D_:$XM\u001c;\u0015\u0005\u0005-\u0002cB\u001b\u0002.\u0005]Q\rQ\u0005\u0004\u0003_1$A\u0002+va2,7'\u0001\u0006sK\u0006$7\u000b\u001e:j]\u001e$\"!!\u000e\u0011\rU\n9$a\u0006f\u0013\r\tID\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0002\rQ|7.\u001a8t+\t\ty\u0004\u0005\u00046\u0003o\u0011\u0018\u0011\t\t\u0004g\u0006\r\u0013bAA#i\nqAj\\2bi&|gnQ1dQ\u0016\u001c\u0018!\u00029beN,WCAA&a\u0011\ti%!\u0018\u0011\r\u0005=\u0013QKA-\u001b\t\t\tFC\u0002\u0002T]\u000baA^1mk\u0016\u001c\u0018\u0002BA,\u0003#\u0012QAV1mk\u0016\u0004B!a\u0017\u0002^1\u0001AaCA0%\u0005\u0005\t\u0011!B\u0001\u0003C\u00121a\u0018\u00132#\u0011\t\u0019'!\u001b\u0011\u0007U\n)'C\u0002\u0002hY\u0012qAT8uQ&tw\rE\u00026\u0003WJ1!!\u001c7\u0005\r\te._\u0001\ne\u0016\fGMV1mk\u0016$2A[A:\u0011\u001d\tyb\u0005a\u0001\u0003C\t!B]3bI:+XNY3s)\u0005)\u0017a\u0002:fC\u0012Le\u000e\u001e\u000b\u0002U\u0006A!/Z1e\rJ\f7-A\u0004sK\u0006$W\t\u001f9\u0002'I,\u0017\rZ(oK>\u0013Xj\u001c:f\t&<\u0017\u000e^:\u0002)I,\u0017\r\u001a.fe>|%/T8sK\u0012Kw-\u001b;tQ\rI\u0012q\u0011\t\u0005\u0003\u0013\u000by)\u0004\u0002\u0002\f*\u0019\u0011Q\u0012\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0012\u0006-%a\u0002;bS2\u0014XmY\u0001\ne\u0016\fG\rR5hSR$\"!!\t\u0002\u000b%tg.\u001a:\u0015\u001b)\fY*a(\u00022\u0006U\u0016QXAd\u0011\u001d\tij\u0007a\u0001\u0003/\t!!\u0019;\t\u000f\u0005\u00056\u00041\u0001\u0002$\u0006)1\u000f^1siB!\u0011QUAV\u001d\ry\u0016qU\u0005\u0004\u0003S\u0003\u0013!\u0004&t_:$vn[3o)f\u0004X-\u0003\u0003\u0002.\u0006=&!\u0004&t_:$vn[3o)f\u0004XMC\u0002\u0002*\u0002Bq!a-\u001c\u0001\u0004\t\u0019+A\u0002f]\u0012Dq!a&\u001c\u0001\u0004\t9\f\u0005\u00036\u0003sS\u0017bAA^m\tIa)\u001e8di&|g\u000e\r\u0005\b\u0003\u007f[\u0002\u0019AAa\u0003\r\u0011X-\u001d\t\u0004k\u0005\r\u0017bAAcm\t!1\t[1s\u0011\u001d\tyb\u0007a\u0001\u0003C\t!B]3bI>\u0013'.Z2u\u0003E\u0011X-\u00193PE*,7\r^'f[\n,'o\u001d\u0015\u0004;\u0005\u001d\u0015!\u0003:fC\u0012\f%O]1z\u0001")
public class IndexedJsonTokenizer
implements JsonTokenizer {
    private final String name;
    private final SourceReader input;
    private final EvaluationContext ctx;
    private int depth;
    private final TokenArray tokenBuffer;
    private final LocationCacheBuilder lcBuilder;
    private long cursorCharLocation;
    private char cursorChar;
    private final char[] strBuffer;

    @Override
    public char currentChar() {
        return JsonTokenizer.currentChar$(this);
    }

    @Override
    public JsonLocation location() {
        return JsonTokenizer.location$(this);
    }

    @Override
    public String parseString() {
        return JsonTokenizer.parseString$(this);
    }

    @Override
    public boolean readChar() {
        return JsonTokenizer.readChar$(this);
    }

    @Override
    public void readEscapedChar(Option<scala.collection.mutable.StringBuilder> target) {
        JsonTokenizer.readEscapedChar$(this, target);
    }

    @Override
    public Option<scala.collection.mutable.StringBuilder> readEscapedChar$default$1() {
        return JsonTokenizer.readEscapedChar$default$1$(this);
    }

    @Override
    public void eof() {
        JsonTokenizer.eof$(this);
    }

    @Override
    public void requireFalse() {
        JsonTokenizer.requireFalse$(this);
    }

    @Override
    public void requireNull() {
        JsonTokenizer.requireNull$(this);
    }

    @Override
    public void requireTrue() {
        JsonTokenizer.requireTrue$(this);
    }

    @Override
    public boolean advance() {
        return JsonTokenizer.advance$(this);
    }

    @Override
    public boolean advanceChar() {
        return JsonTokenizer.advanceChar$(this);
    }

    @Override
    public boolean ws(char c) {
        return JsonTokenizer.ws$(this, c);
    }

    @Override
    public final void ws() {
        JsonTokenizer.ws$(this);
    }

    @Override
    public boolean advanceIf(char c) {
        return JsonTokenizer.advanceIf$(this, c);
    }

    @Override
    public void require(char c) {
        JsonTokenizer.require$(this, c);
    }

    @Override
    public boolean advanceCharIf(char c) {
        return JsonTokenizer.advanceCharIf$(this, c);
    }

    @Override
    public void requireChar(char c) {
        JsonTokenizer.requireChar$(this, c);
    }

    @Override
    public Nothing$ fail(String target, JsonLocation location, char errorChar) {
        return JsonTokenizer.fail$(this, target, location, errorChar);
    }

    @Override
    public JsonLocation fail$default$2() {
        return JsonTokenizer.fail$default$2$(this);
    }

    @Override
    public char fail$default$3() {
        return JsonTokenizer.fail$default$3$(this);
    }

    @Override
    public long cursorCharLocation() {
        return this.cursorCharLocation;
    }

    @Override
    public void cursorCharLocation_$eq(long x$1) {
        this.cursorCharLocation = x$1;
    }

    @Override
    public char cursorChar() {
        return this.cursorChar;
    }

    @Override
    public void cursorChar_$eq(char x$1) {
        this.cursorChar = x$1;
    }

    @Override
    public char[] strBuffer() {
        return this.strBuffer;
    }

    @Override
    public void org$mule$weave$v2$module$core$json$reader$JsonTokenizer$_setter_$strBuffer_$eq(char[] x$1) {
        this.strBuffer = x$1;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SourceReader input() {
        return this.input;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private TokenArray tokenBuffer() {
        return this.tokenBuffer;
    }

    private LocationCacheBuilder lcBuilder() {
        return this.lcBuilder;
    }

    public void addToken(long[] token, boolean putTokenInLC) {
        block0: {
            this.tokenBuffer().$plus$eq(token);
            if (!putTokenInLC) break block0;
            this.lcBuilder().addToken(token, this.tokenBuffer().length() - 1L);
        }
    }

    public Tuple3<Object, Object, String> readStringContent() {
        this.requireChar('\"');
        long start = this.cursorCharLocation();
        String str = this.parseString();
        int length = (int)(this.cursorCharLocation() - start);
        this.require('\"');
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)start), (Object)BoxesRunTime.boxToInteger((int)length), (Object)str);
    }

    public Tuple2<Object, Object> readString() {
        this.require('\"');
        long start = this.cursorCharLocation();
        while (this.readChar()) {
            this.advance();
        }
        int length = (int)(this.cursorCharLocation() - start);
        this.require('\"');
        return new Tuple2.mcJI.sp(start, length);
    }

    public Tuple2<TokenArray, LocationCaches> tokens() {
        this.ws();
        this.readValue(true);
        LocationCaches locationCaches = (LocationCaches)this.ctx.registerCloseable((AutoCloseable)this.lcBuilder().build());
        this.ws();
        this.eof();
        return new Tuple2((Object)this.tokenBuffer(), (Object)locationCaches);
    }

    public Value<?> parse() {
        Tuple2<TokenArray, LocationCaches> tokens1 = this.tokens();
        return JsonRootValue$.MODULE$.apply((TokenArray)tokens1._1(), (LocationCaches)tokens1._2(), this.input(), this.name());
    }

    private void readValue(boolean putTokenInLC) {
        this.ws();
        long at = this.cursorCharLocation();
        char c = this.cursorChar();
        switch (c) {
            case 'f': {
                this.requireFalse();
                this.addToken(JsonTokenHelper$.MODULE$.createFalse(this.depth(), at), putTokenInLC);
                break;
            }
            case 't': {
                this.requireTrue();
                this.addToken(JsonTokenHelper$.MODULE$.createTrue(this.depth(), at), putTokenInLC);
                break;
            }
            case 'n': {
                this.requireNull();
                this.addToken(JsonTokenHelper$.MODULE$.createNull(this.depth(), at), putTokenInLC);
                break;
            }
            case '{': {
                this.inner(at, JsonTokenType$.MODULE$.ObjectStart(), JsonTokenType$.MODULE$.ObjectEnd(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readObject(), '}', putTokenInLC);
                break;
            }
            case '[': {
                this.inner(at, JsonTokenType$.MODULE$.ArrayStart(), JsonTokenType$.MODULE$.ArrayEnd(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.readArray(), ']', putTokenInLC);
                break;
            }
            case '\"': {
                Tuple2<Object, Object> tuple2 = this.readString();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                long offset = tuple2._1$mcJ$sp();
                int length = tuple2._2$mcI$sp();
                Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(offset, length);
                Tuple2.mcJI.sp sp3 = sp2;
                long offset2 = sp3._1$mcJ$sp();
                int length2 = sp3._2$mcI$sp();
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.String(), this.depth(), offset2, length2), putTokenInLC);
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.Number(), this.depth(), at, this.readNumber()), putTokenInLC);
                break;
            }
            default: {
                throw this.fail(new StringBuilder(59).append("false or true or null or {...} or [...] or number but was ").append(this.cursorChar()).append(".").toString(), this.fail$default$2(), this.fail$default$3());
            }
        }
    }

    private int readNumber() {
        long start = this.cursorCharLocation();
        this.advanceIf('-');
        this.readInt();
        this.readFrac();
        this.readExp();
        return (int)(this.cursorCharLocation() - start);
    }

    private void readInt() {
        block0: {
            if (this.advanceIf('0')) break block0;
            this.readOneOrMoreDigits();
        }
    }

    private void readFrac() {
        block0: {
            if (!this.advanceIf('.')) break block0;
            this.readOneOrMoreDigits();
        }
    }

    private void readExp() {
        block0: {
            if (!this.advanceIf('e') && !this.advanceIf('E')) break block0;
            boolean bl = this.advanceIf('-') || this.advanceIf('+');
            this.readOneOrMoreDigits();
        }
    }

    private void readOneOrMoreDigits() {
        if (!this.readDigit()) {
            throw this.fail("readDigit", this.fail$default$2(), this.fail$default$3());
        }
        this.readZeroOrMoreDigits();
    }

    public final void readZeroOrMoreDigits() {
        while (this.readDigit()) {
        }
    }

    public boolean readDigit() {
        return this.cursorChar() >= '0' && this.cursorChar() <= '9' && this.advance();
    }

    private void inner(long at, int start, int end, Function0<BoxedUnit> inner, char req, boolean putTokenInLC) {
        long[] startToken = JsonTokenHelper$.MODULE$.create(start, this.depth(), at, 1L);
        this.addToken(startToken, putTokenInLC);
        this.advance();
        this.depth_$eq(this.depth() + 1);
        inner.apply$mcV$sp();
        this.depth_$eq(this.depth() - 1);
        this.ws();
        this.require(req);
    }

    private void readObject() {
        block0: {
            this.ws();
            if (this.cursorChar() == '}') break block0;
            this.readObjectMembers();
        }
    }

    private void readObjectMembers() {
        do {
            this.ws();
            Tuple3<Object, Object, String> tuple3 = this.readStringContent();
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
            int length = BoxesRunTime.unboxToInt((Object)tuple3._2());
            String keyName = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)offset), (Object)BoxesRunTime.boxToInteger((int)length), (Object)keyName);
            Tuple3 tuple33 = tuple32;
            long offset2 = BoxesRunTime.unboxToLong((Object)tuple33._1());
            int length2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            String keyName2 = (String)tuple33._3();
            this.addToken(JsonTokenHelper$.MODULE$.createKey(keyName2, JsonTokenType$.MODULE$.Key(), this.depth(), offset2, length2), true);
            this.ws();
            this.require(':');
            this.ws();
            this.readValue(false);
        } while (this.ws(','));
    }

    private void readArray() {
        block0: {
            this.ws();
            if (this.cursorChar() == ']') break block0;
            this.values$1();
        }
    }

    private final void values$1() {
        do {
            this.readValue(true);
        } while (this.ws(','));
    }

    public IndexedJsonTokenizer(String name, SourceReader input, EvaluationContext ctx) {
        this.name = name;
        this.input = input;
        this.ctx = ctx;
        JsonTokenizer.$init$(this);
        this.depth = 0;
        this.tokenBuffer = (TokenArray)ctx.registerCloseable((AutoCloseable)new TokenArray(TokenArray$.MODULE$.$lessinit$greater$default$1(), ctx));
        this.lcBuilder = new LocationCacheBuilder(JsonTokenHelper$.MODULE$, ctx);
    }
}

