/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.handler;

import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.SchemaHandler;

public class ReferenceHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof ReferenceSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        Schema referredSchema = ((ReferenceSchema)schema).getReferredSchema();
        TypeBuilder<?> referenceType = handlerManager.handle(referredSchema, parsingContext);
        String title = schema.getTitle();
        if (StringUtils.isNotEmpty((String)title)) {
            if (referenceType instanceof ArrayTypeBuilder) {
                ((ArrayTypeBuilder)referenceType).label(title);
            } else if (referenceType instanceof TupleTypeBuilder) {
                ((TupleTypeBuilder)referenceType).label(title);
            } else if (referenceType instanceof ObjectTypeBuilder) {
                ((ObjectTypeBuilder)referenceType).label(title);
            } else if (referenceType instanceof ObjectFieldTypeBuilder) {
                ((ObjectFieldTypeBuilder)referenceType).label(title);
            }
        }
        return referenceType;
    }
}

