/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.domain.request.ServerConnection;
import org.mule.service.http.netty.impl.server.NettyClientConnection;
import org.mule.service.http.netty.impl.server.NettyServerConnection;

public class NettyHttpRequestContext
implements HttpRequestContext {
    private final HttpRequest request;
    private final NettyServerConnection serverConnection;
    private final NettyClientConnection clientConnection;
    private final String scheme;

    public NettyHttpRequestContext(HttpRequest request, ChannelHandlerContext ctx, SslHandler sslHandler) {
        this.request = request;
        this.serverConnection = new NettyServerConnection((InetSocketAddress)ctx.channel().localAddress());
        this.clientConnection = new NettyClientConnection((InetSocketAddress)ctx.channel().remoteAddress(), sslHandler);
        this.scheme = sslHandler != null ? "https" : "http";
    }

    public String getScheme() {
        return this.scheme;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public ServerConnection getServerConnection() {
        return this.serverConnection;
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }
}

