/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.internal.event.EventContextDeepNestingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;

public class DefaultFlowCallStack
implements FlowCallStack {
    private static final long serialVersionUID = -8683711977929802819L;
    private static final int MAX_DEPTH = Integer.getInteger("mule.flowStack.maxDepth", Integer.getInteger(BaseEventContext.class.getName() + ".maxDepth", 45));
    private final Deque<FlowStackElement> innerStack;

    public static DefaultFlowCallStack newDefaultFlowCallStack() {
        return new DefaultFlowCallStack();
    }

    private DefaultFlowCallStack() {
        this.innerStack = new ArrayDeque<FlowStackElement>(4);
    }

    private DefaultFlowCallStack(Deque<FlowStackElement> innerStack) {
        this.innerStack = ((ArrayDeque)innerStack).clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(FlowStackElement flowStackElement) {
        if (this.innerStack.size() >= MAX_DEPTH) {
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("Too many nested child contexts.").append(System.lineSeparator()).append(this.toString());
            throw new EventContextDeepNestingException(messageBuilder.toString());
        }
        Deque<FlowStackElement> deque = this.innerStack;
        synchronized (deque) {
            this.innerStack.push(flowStackElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushCurrentProcessorPath(String processorPath) {
        if (!this.innerStack.isEmpty()) {
            Deque<FlowStackElement> deque = this.innerStack;
            synchronized (deque) {
                FlowStackElement stackElement = this.innerStack.pop();
                this.innerStack.push(new FlowStackElement(stackElement.getFlowName(), stackElement.getChainIdentifier(), processorPath));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowStackElement pop() {
        Deque<FlowStackElement> deque = this.innerStack;
        synchronized (deque) {
            return this.innerStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowStackElement peek() {
        Deque<FlowStackElement> deque = this.innerStack;
        synchronized (deque) {
            return this.innerStack.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FlowStackElement> getElements() {
        Deque<FlowStackElement> deque = this.innerStack;
        synchronized (deque) {
            return new ArrayList<FlowStackElement>(this.innerStack);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultFlowCallStack clone() {
        Deque<FlowStackElement> deque = this.innerStack;
        synchronized (deque) {
            return new DefaultFlowCallStack(this.innerStack);
        }
    }

    public String toString() {
        return this.doToString(FlowStackElement::toString);
    }

    public String toStringWithElapsedTime() {
        return this.doToString(FlowStackElement::toStringWithElapsedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doToString(Function<FlowStackElement, String> toString) {
        StringBuilder stackString = new StringBuilder(256);
        int i = 0;
        Deque<FlowStackElement> deque = this.innerStack;
        synchronized (deque) {
            for (FlowStackElement flowStackElement : this.innerStack) {
                stackString.append("at ").append(toString.apply(flowStackElement));
                if (++i == this.innerStack.size()) continue;
                stackString.append(System.lineSeparator());
            }
        }
        return stackString.toString();
    }
}

