/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.HasLocation;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.profiling.tracing.ComponentTracerAware;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class DefaultMessageProcessorChainBuilder
extends AbstractMessageProcessorChainBuilder
implements ComponentTracerAware<CoreEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageProcessorChainBuilder.class);

    @Override
    public MessageProcessorChain build() {
        LinkedList<Processor> tempList = new LinkedList<Processor>();
        for (int i = this.processors.size() - 1; i >= 0; --i) {
            Processor processor = this.initializeMessageProcessor(this.processors.get(i));
            tempList.addFirst(processor);
        }
        return this.createSimpleChain(tempList, Optional.ofNullable(this.processingStrategy));
    }

    protected MessageProcessorChain createSimpleChain(List<Processor> tempList, Optional<ProcessingStrategy> processingStrategyOptional) {
        DefaultMessageProcessorChain messageProcessorChain = tempList.size() == 1 && tempList.get(0) instanceof DefaultMessageProcessorChain ? (DefaultMessageProcessorChain)tempList.get(0) : new DefaultMessageProcessorChain(this.name != null ? "(chain) of " + this.name : "(chain)", processingStrategyOptional, new ArrayList<Processor>(tempList), this.messagingExceptionHandler, this.location);
        if (this.chainComponentTracer != null) {
            messageProcessorChain.setComponentTracer((ComponentTracer<CoreEvent>)this.chainComponentTracer);
        }
        return messageProcessorChain;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(Processor ... processors) {
        for (Processor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chain(List<Processor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(Processor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    @Override
    public void setComponentTracer(ComponentTracer<CoreEvent> componentTracer) {
        this.chainComponentTracer = componentTracer;
    }

    public static MessageProcessorChain newLazyProcessorChainBuilder(AbstractMessageProcessorChainBuilder chainBuilder, MuleContext muleContext, Supplier<ProcessingStrategy> processingStrategySupplier) {
        return new LazyProcessorChainBuilder(chainBuilder.name, Optional.empty(), chainBuilder.processors, chainBuilder, processingStrategySupplier);
    }

    private static final class LazyProcessorChainBuilder
    extends AbstractMessageProcessorChain
    implements MessagingExceptionHandlerAware,
    ComponentTracerAware<CoreEvent> {
        private final AbstractMessageProcessorChainBuilder chainBuilder;
        private final Supplier<ProcessingStrategy> processingStrategySupplier;
        private FlowExceptionHandler messagingExceptionHandler;
        private MessageProcessorChain delegate;
        private ComponentTracer<CoreEvent> chainComponentTracer;

        private LazyProcessorChainBuilder(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, AbstractMessageProcessorChainBuilder chainBuilder, Supplier<ProcessingStrategy> processingStrategySupplier) {
            super(name, processingStrategyOptional, processors, null);
            this.chainBuilder = chainBuilder;
            this.processingStrategySupplier = processingStrategySupplier;
        }

        @Override
        public void initialise() throws InitialisationException {
            this.chainBuilder.setProcessingStrategy(this.processingStrategySupplier.get());
            this.chainBuilder.setMessagingExceptionHandler(this.messagingExceptionHandler);
            this.chainBuilder.setComponentTracer(this.chainComponentTracer);
            this.delegate = this.chainBuilder.build();
            this.delegate.setAnnotations(this.getAnnotations());
            LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
        }

        @Override
        public void start() throws MuleException {
            LifecycleUtils.startIfNeeded(this.delegate);
        }

        @Override
        public void dispose() {
            LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        }

        @Override
        public void stop() throws MuleException {
            LifecycleUtils.stopIfNeeded(this.delegate);
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return this.delegate.process(event);
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return this.delegate.apply(publisher);
        }

        @Override
        public void setMessagingExceptionHandler(FlowExceptionHandler messagingExceptionHandler) {
            this.messagingExceptionHandler = messagingExceptionHandler;
        }

        @Override
        public void setComponentTracer(ComponentTracer<CoreEvent> chainComponentTracer) {
            this.chainComponentTracer = chainComponentTracer;
        }
    }

    public static interface MessagingExceptionHandlerAware {
        public void setMessagingExceptionHandler(FlowExceptionHandler var1);
    }

    @NoExtend
    protected static class DefaultMessageProcessorChain
    extends AbstractMessageProcessorChain
    implements HasLocation {
        private ComponentLocation pipeLineLocation;

        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, FlowExceptionHandler messagingExceptionHandler) {
            this(name, processingStrategyOptional, processors, messagingExceptionHandler, null);
        }

        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, FlowExceptionHandler messagingExceptionHandler, ComponentLocation pipeLineLocation) {
            super(name, processingStrategyOptional, processors, messagingExceptionHandler);
            this.pipeLineLocation = pipeLineLocation;
        }

        @Deprecated
        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, processingStrategyOptional, processors, (exception, event) -> null);
        }

        @Override
        public ComponentLocation resolveLocation() {
            return this.pipeLineLocation;
        }
    }
}

