/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.cache;

import java.io.File;
import java.net.URI;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryPublic;
import org.xmlresolver.catalog.entry.EntrySystem;
import org.xmlresolver.catalog.entry.EntryUri;
import org.xmlresolver.utils.PublicId;

public class CacheEntry {
    public final Entry entry;
    public final URI uri;
    public final File file;
    public final long time;
    public boolean expired;

    protected CacheEntry(EntryUri entry, long time) {
        this.entry = entry;
        this.uri = entry.baseURI.resolve(entry.name);
        this.file = new File(entry.uri.getPath());
        this.time = time;
    }

    protected CacheEntry(EntrySystem entry, long time) {
        this.entry = entry;
        this.uri = entry.baseURI.resolve(entry.systemId);
        this.file = new File(entry.uri.getPath());
        this.time = time;
    }

    protected CacheEntry(EntryPublic entry, long time) {
        this.entry = entry;
        this.uri = PublicId.encodeURN(entry.publicId);
        this.file = new File(entry.uri.getPath());
        this.time = time;
    }

    public String etag() {
        return this.entry.getProperty("etag");
    }

    public String contentType() {
        return this.entry.getProperty("contentType");
    }

    public URI location() {
        if (this.entry.getProperty("redir") != null) {
            return this.uri.resolve(this.entry.getProperty("redir"));
        }
        return this.uri;
    }

    public String toString() {
        return this.file.getAbsolutePath();
    }
}

