/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.xpointer;

import java.io.PrintWriter;
import org.mule.apache.xerces.xni.XNIException;
import org.mule.apache.xerces.xni.parser.XMLErrorHandler;
import org.mule.apache.xerces.xni.parser.XMLParseException;

final class XPointerErrorHandler
implements XMLErrorHandler {
    protected PrintWriter fOut;

    public XPointerErrorHandler() {
        this(new PrintWriter(System.err));
    }

    public XPointerErrorHandler(PrintWriter out) {
        this.fOut = out;
    }

    @Override
    public void warning(String domain, String key, XMLParseException ex) throws XNIException {
        this.printError("Warning", ex);
    }

    @Override
    public void error(String domain, String key, XMLParseException ex) throws XNIException {
        this.printError("Error", ex);
    }

    @Override
    public void fatalError(String domain, String key, XMLParseException ex) throws XNIException {
        this.printError("Fatal Error", ex);
        throw ex;
    }

    private void printError(String type, XMLParseException ex) {
        this.fOut.print("[");
        this.fOut.print(type);
        this.fOut.print("] ");
        String systemId = ex.getExpandedSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            this.fOut.print(systemId);
        }
        this.fOut.print(':');
        this.fOut.print(ex.getLineNumber());
        this.fOut.print(':');
        this.fOut.print(ex.getColumnNumber());
        this.fOut.print(": ");
        this.fOut.print(ex.getMessage());
        this.fOut.println();
        this.fOut.flush();
    }
}

