/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder.adapter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.MetadataTypeAdapter;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapterWithStereotype;
import org.mule.runtime.ast.internal.builder.adapter.ObjectTypeAsParameterGroupAdapter;
import org.mule.runtime.ast.internal.model.DefaultExtensionModelHelper;
import org.mule.runtime.extension.api.declaration.type.annotation.StereotypeTypeAnnotation;
import org.mule.runtime.extension.api.util.NameUtils;

public class MetadataTypeModelAdapter
implements ParameterizedModel,
MetadataTypeAdapter {
    private final MetadataType type;
    private final List<ParameterGroupModel> parameterGroupModels;

    public static Optional<MetadataTypeModelAdapter> createMetadataTypeModelAdapterWithStereotype(MetadataType type, DefaultExtensionModelHelper extensionModelHelper) {
        return type.getAnnotation(StereotypeTypeAnnotation.class).flatMap(sta -> sta.getAllowedStereotypes().stream().findFirst()).map(st -> new MetadataTypeModelAdapterWithStereotype(type, (StereotypeModel)st, extensionModelHelper));
    }

    public static MetadataTypeModelAdapter createSimpleWrapperTypeModelAdapter(SimpleType simpleType, DefaultExtensionModelHelper extensionModelHelper) {
        ObjectTypeBuilder entryObjectTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
        entryObjectTypeBuilder.addField().key("value").value((MetadataType)simpleType);
        return new MetadataTypeModelAdapter((MetadataType)entryObjectTypeBuilder.build(), extensionModelHelper){

            @Override
            public boolean isWrapperFor(MetadataType type) {
                return type instanceof StringType || super.isWrapperFor(type);
            }
        };
    }

    public static MetadataTypeModelAdapter createKeyValueWrapperTypeModelAdapter(String keyParamName, MetadataType simpleKeyType, String valueParamName, MetadataType simpleValueType, DefaultExtensionModelHelper extensionModelHelper) {
        ObjectTypeBuilder entryObjectTypeBuilder = new BaseTypeBuilder(MetadataFormat.JAVA).objectType();
        entryObjectTypeBuilder.addField().key(keyParamName).value(simpleKeyType);
        entryObjectTypeBuilder.addField().key(valueParamName).value(simpleValueType);
        return new MetadataTypeModelAdapter((MetadataType)entryObjectTypeBuilder.build(), extensionModelHelper);
    }

    public static MetadataTypeModelAdapter createParameterizedTypeModelAdapter(MetadataType type, DefaultExtensionModelHelper extensionModelHelper) {
        return new MetadataTypeModelAdapter(type, extensionModelHelper);
    }

    MetadataTypeModelAdapter(MetadataType type, DefaultExtensionModelHelper extensionModelHelper) {
        this.type = type;
        this.parameterGroupModels = type instanceof ObjectType ? Collections.singletonList(new ObjectTypeAsParameterGroupAdapter((ObjectType)type, extensionModelHelper.findMetadataType(String.class).orElse(null))) : Collections.emptyList();
    }

    public String getName() {
        return NameUtils.getAliasName((MetadataType)this.type);
    }

    public String getDescription() {
        return "MetadataTypeModelAdapter for " + MetadataTypeUtils.getTypeId((MetadataType)this.type).orElse(this.type.toString());
    }

    public List<ParameterGroupModel> getParameterGroupModels() {
        return this.parameterGroupModels;
    }

    @Override
    public MetadataType getType() {
        return this.type;
    }

    @Override
    public boolean isWrapperFor(MetadataType type) {
        return this.type.equals(type);
    }

    public String toString() {
        return "MetadataTypeModelAdapter{" + this.type.toString() + "}";
    }
}

