/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client.auth.ntlm.message;

public abstract class NtlmMessage {
    protected static final byte[] NTLMSSP_SIGNATURE = new byte[]{78, 84, 76, 77, 83, 83, 80, 0};
    protected static final int NTLMSSP_TYPE1 = 1;
    protected static final int NTLMSSP_TYPE2 = 2;
    protected static final int NTLMSSP_TYPE3 = 3;
    private static final String OEM_ENCODING = "Cp850";
    protected static final String UNI_ENCODING = "UTF-16LE";
    protected static final byte[] NTLMSSP_VERSION = new byte[]{6, 1, 0, 0, 0, 0, 0, 15};
    private int flags;

    public NtlmMessage() {
    }

    public NtlmMessage(int flags) {
        this.flags = flags;
    }

    static void writeULong(byte[] dest, int offset, int ulong) {
        dest[offset] = (byte)(ulong & 0xFF);
        dest[offset + 1] = (byte)(ulong >> 8 & 0xFF);
        dest[offset + 2] = (byte)(ulong >> 16 & 0xFF);
        dest[offset + 3] = (byte)(ulong >> 24 & 0xFF);
    }

    static int writeSecurityBuffer(byte[] dest, int offset, byte[] src) {
        int length;
        int n = length = src != null ? src.length : 0;
        if (length == 0) {
            return offset + 4;
        }
        NtlmMessage.writeUShort(dest, offset, length);
        NtlmMessage.writeUShort(dest, offset + 2, length);
        return offset + 4;
    }

    static void writeUShort(byte[] dest, int offset, int ushort) {
        dest[offset] = (byte)(ushort & 0xFF);
        dest[offset + 1] = (byte)(ushort >> 8 & 0xFF);
    }

    static int writeSecurityBufferContent(byte[] dest, int pos, int off, byte[] src) {
        NtlmMessage.writeULong(dest, off, pos);
        if (src != null && src.length > 0) {
            System.arraycopy(src, 0, dest, pos, src.length);
            return src.length;
        }
        return 0;
    }

    static int readULong(byte[] src, int index) {
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8 | (src[index + 2] & 0xFF) << 16 | (src[index + 3] & 0xFF) << 24;
    }

    static byte[] readSecurityBuffer(byte[] src, int index) {
        int length = NtlmMessage.readUShort(src, index);
        int offset = NtlmMessage.readULong(src, index + 4);
        byte[] buffer = new byte[length];
        System.arraycopy(src, offset, buffer, 0, length);
        return buffer;
    }

    static int readUShort(byte[] src, int index) {
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8;
    }

    static String getOEMEncoding() {
        return OEM_ENCODING;
    }

    public boolean getFlag(int flag) {
        return (this.getFlags() & flag) != 0;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlag(int flag, boolean value) {
        this.setFlags(value ? this.getFlags() | flag : this.getFlags() & (0xFFFFFFFF ^ flag));
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }
}

